<form method="post" enctype="multipart/form-data" class="validate-form confirm_pos_booking" action="<?php echo base_url('admin/pos/confirm_pos_booking')?>" role="form" novalidate>
  <div class="row">
    <div class="col-md-6">
      <div class="card">
        <div class="card-body">
          <h5>Confirm Booking</h5>

          <div class="form-group mt-3">
            <label class="text-dark-75 h6">Payment Method</label>
            <select class="form-control pos_payment_method" name="pos_payment_method" required>
                <option value=""><?php echo trans('select') ?></option>
                <?php $method = $this->session->userdata('pos_payment_method'); ?>
                <option value="cash" <?php if(isset($method) && $method == 'cash'){echo 'selected';} ?>>Cash</option>
                <option value="card" <?php if(isset($method) && $method == 'card'){echo 'selected';} ?>>Card</option>
            </select>
          </div>

          <div class="form-group mt-3">
            <label>Received amount</label>
            <div class="input-group">
              <input type="number" class="form-control pos_received_amount" name="pos_received_amount" value="">
              <div class="input-group-append">
                <span class="input-group-text"><?php echo html_escape($this->business->currency_symbol) ?></span>
              </div>
            </div>
          </div>
          <?php echo my_date_show($this->session->userdata('date')) ?>

          <div class="form-group mt-3">
            <label>Paying amount</label>
            <div class="input-group">
              <input type="number" class="form-control pos_paying_amount" name="pos_paying_amount" value="" disabled>
              <div class="input-group-append">
                <span class="input-group-text"><?php echo html_escape($this->business->currency_symbol) ?></span>
              </div>
            </div>
          </div>

          <div class="mt-3">
            <h5>Chang Return</h5>
            <span class="pos_change_return">0</span>
            <span><?php echo html_escape($this->business->currency_symbol) ?></span>
          </div>

          <div class="form-group mt-3">
            <label>Payment Notes</label>
            <textarea class="form-control" name="payment_note" rows="3"></textarea>
          </div>
        </div>
      </div>
    </div>
     <div class="col-md-6">
        <div class="card">
          <div class="card-body">
            <h5>Service</h5>

            <div class="d-flex justify-content-between">

              <div>
                <p><?php echo get_by_id($this->session->userdata('service_id'),'services')->name ?></p>
              </div>
              <div class="pr-5">
                <span class="text-muted">
                  <?php if (get_by_id($this->session->userdata('service_id'),'services')->price == 0 ): ?>
                      <?php echo trans('free') ?>
                  <?php else: ?>
                      <?php if($this->business->curr_locate == 0){echo get_currency_by_country($this->business->country)->currency_symbol;} ?> <?php echo number_format(get_by_id($this->session->userdata('service_id'),'services')->price, $this->business->num_format) ?> <?php if($this->business->curr_locate == 1){echo get_currency_by_country($this->business->country)->currency_symbol;} ?>
                  <?php endif ?>
                </span>
              </div>
              
            </div>
            

            <?php if(!empty($this->session->userdata('service_extra'))): ?>
              <h5>Service extra</h5>
             <?php  $service_extras = explode(',', $this->session->userdata('service_extra')); ?>

             <?php foreach ($service_extras as $value): ?>

              <div class="d-flex justify-content-between">
                <div>
                  <p class="mt-0 mb-0"><?php echo get_by_id($value,'service_extra')->name; ?></p>
                </div>
                <div class="pr-5">
                  <?php if($this->business->curr_locate == 0){echo get_currency_by_country($this->business->country)->currency_symbol;} ?> <?php echo number_format(get_by_id($value,'service_extra')->price, $this->business->num_format) ?> <?php if($this->business->curr_locate == 1){echo get_currency_by_country($this->business->country)->currency_symbol;} ?>
                </div>
              </div>
             <?php endforeach ?>
            <?php endif; ?>


            <div class="d-flex justify-content-between mb-1 bm-1 pb-1 pr-5 mt-5">
              <div class="mr-5">
               <p class="mb-1 text-dark-75 h6">Sub total</p>
              </div>

              <div class="text-left">
                <p class="mb-1 text-muted fs-15 ml-3">
                  <?php if($this->business->curr_locate == 0){echo get_currency_by_country($this->business->country)->currency_symbol;} ?> <span class="step2_sub_total text-muted"></span> <?php if($this->business->curr_locate == 1){echo get_currency_by_country($this->business->country)->currency_symbol;} ?>
                </p>
              </div>
            </div>

            <div class="d-flex justify-content-between mb-1 bm-1 pb-1 pr-5">
              <div class="mr-5">
               <p class="mb-1 text-dark-75 h6">Discount</p>
              </div>

              <div class="text-left">
                <p class="mb-1 text-muted fs-15 ml-3">
                  <?php if($this->business->curr_locate == 0){echo get_currency_by_country($this->business->country)->currency_symbol;} ?> <span class="step2_coupon_amount text-muted"></span> <?php if($this->business->curr_locate == 1){echo get_currency_by_country($this->business->country)->currency_symbol;} ?>
                </p>
              </div>
            </div>

            <div class="d-flex justify-content-between mb-1 bm-1 pb-1 pr-5">
              <div class="mr-5">
               <p class="mb-1 text-dark-75 h6">Total</p>
              </div>

              <div class="text-left">
                <p class="mb-1 text-muted fs-15 ml-3">
                  <?php if($this->business->curr_locate == 0){echo get_currency_by_country($this->business->country)->currency_symbol;} ?> <span class="step2_total text-muted"></span> <?php if($this->business->curr_locate == 1){echo get_currency_by_country($this->business->country)->currency_symbol;} ?>
                </p>
              </div>
            </div>

            <button type="button" class="btn btn-secondary pos_step2_back">Back</button>
            <button type="submit" class="btn btn-primary confirm_pos_booking_btn">Confirm</button>

            <input type="hidden" name="invoice_sub_total" class="invoice_sub_total" value="">
            <input type="hidden" name="invoice_total" class="invoice_total" value="">
            <input type="hidden" name="invoice_coupon_amount" class="invoice_coupon_amount" value="">

          </div>
        </div>
    </div>
  </div>
</form>