<div class="content-wrapper">

  <!-- Content Header (Page header) -->
  <?php $this->load->view('admin/include/breadcrumb'); ?>

  <!-- Main content -->
  <div class="content">
    <div class="container-fluid">
      

      <div class="row">
        <div class="col-md-8">
          <div class="d-flex justify-content-between mb-3">
            <div><h5>Invoice</h5></div>
            <div class="pr-5">
              <span><a href="#" class="btn btn-secondary print_invoice">Print</a></span>
              <span><a href="#" class="btn btn-secondary pos_print" >Pos Print</a></span>
            </div>
          </div>
          <div class="card print_area">
            <div class="card-body">
              <div class="d-flex justify-content-between mt-3">
                <div>
                  <h5>Booking Id : #<?php echo html_escape($payment->booking_number) ?></h5>

                  <span class="badge badge-success mr-2">Paid</span>
                  <span><?php echo my_date_show($payment->created_at) ?></span>
                </div>
                <div></div>
              </div>
              <hr class="devider">

              <div class="d-flex justify-content-between mt-3 mb-5">
                <div class="cus_info">
                  <h6 class="mb-1"><?php echo html_escape($payment->customer_name) ?></h6>
                  <p class="mt-0 mb-0"><?php echo html_escape($payment->customer_email) ?></p>
                  <p class="mt-0 mb-0"><?php echo html_escape($payment->customer_phone) ?></p>
                </div>

                <div class="business_info">
                  <h6 class="mb-1"><?php echo html_escape($this->business->name) ?></h6>
                  <p class="mt-0 mb-0"><?php echo html_escape($this->business->email) ?></p>
                  <p class="mt-0 mb-0"><?php echo html_escape($this->business->phone) ?></p>
                  <p class="mt-0 mb-0"><?php echo html_escape($this->business->address) ?></p>
                </div>
              </div>

              <div class="d-flex justify-content-between mt-3 mb-0">
                <div class="cus_info">
                  <p><?php echo html_escape($payment->service_name) ?></p>
                </div>

                <div class="business_info pr-5">
                  <p class="">
                    <?php if($this->business->curr_locate == 0){echo get_currency_by_country($this->business->country)->currency_symbol;} ?> <span class=""><?php echo html_escape($payment->service_price) ?></span> <?php if($this->business->curr_locate == 1){echo get_currency_by_country($this->business->country)->currency_symbol;} ?>
                  </p>
                </div>
              </div>

              <?php if(!empty($payment->service_extra)): ?>

                <?php $service_extras = explode(',', $payment->service_extra) ?>

                <?php foreach ($service_extras as $service_extra): ?>
                  <div class="d-flex justify-content-between">
                   <span><?php echo get_by_id($service_extra,'service_extra')->name ?></span>
                   <span class="text-right pr-5">
                      <?php if($this->business->curr_locate == 0){echo get_currency_by_country($this->business->country)->currency_symbol;} ?> <span class=""><?php echo get_by_id($service_extra, 'service_extra')->price ?></span> <?php if($this->business->curr_locate == 1){echo get_currency_by_country($this->business->country)->currency_symbol;} ?>
                    </span>
                  </div>
                <?php endforeach ?>

              <?php endif; ?>

              <hr class="devider">

              <div class="calculation text-right pr-5">
                <p class="mt-0 mb-1">
                  <span class="pr-5">Sub Total</span>
                  <span class="show_invoice_sub_total">
                    <?php if($this->business->curr_locate == 0){echo get_currency_by_country($this->business->country)->currency_symbol;} ?> <span class=""><?php echo html_escape($this->session->userdata('invoice_sub_total')) ?></span> <?php if($this->business->curr_locate == 1){echo get_currency_by_country($this->business->country)->currency_symbol;} ?>
                  </span>
                </p>

                <p class="mt-0 mb-1">
                  <span class="pr-5">Discount</span>
                  <span class="show_invoice_coupon_amount">
                    <?php if($this->business->curr_locate == 0){echo get_currency_by_country($this->business->country)->currency_symbol;} ?> <span class=""><?php echo html_escape($this->session->userdata('invoice_coupon_amount')) ?></span> <?php if($this->business->curr_locate == 1){echo get_currency_by_country($this->business->country)->currency_symbol;} ?>
                  </span>
                </p>

                <p class="mt-0 mb-1">
                  <span class="pr-5">Total</span>
                  <span class="show_invoice_total">
                    <?php if($this->business->curr_locate == 0){echo get_currency_by_country($this->business->country)->currency_symbol;} ?> <span class=""><?php echo html_escape($this->session->userdata('invoice_total')) ?></span> <?php if($this->business->curr_locate == 1){echo get_currency_by_country($this->business->country)->currency_symbol;} ?>
                  </span>
                </p>
              </div>

              
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>