<?php if ($template == 2): ?>
    <?php include APPPATH.'views/include/banner2.php'; ?>
<?php endif ?>

<?php $total = get_front_total_value($user->id, 'appointments'); ?>
<?php if (ckeck_front_plan_limit($user->id, 'appointments', $total) == TRUE && $is_embed==false): ?>
<section class="bg-light p-6">
    <div class="container">
        <div class="rows text-center hide-xs">
            <?php if (isset($page_title) && $page_title == 'Booking'): ?>
                    <h4 class="mb-2"><?php echo trans('easy-step-booking-title') ?></h4>
                    <p class="w-100 w-lg-80 mx-auto mb-0"><?php echo trans('easy-step-booking-details') ?></p>
                <?php endif ?>

                <?php if (isset($page_title) && $page_title == 'Booking Confirm'): ?>
                    <h4 class="mb-2"><?php echo trans('confirm-booking-details') ?></h4>
                    <p class="w-100 w-lg-80 mx-auto mb-0"><?php echo trans('you-are-almost-done') ?></p>
                <?php endif ?>
        </div>
    </div>
</section>
<?php endif ?>

<section class="pt-0 mt-6 mb-4 <?php if(settings()->site_info == 3){echo "d-none";} ?>">
    <div class="container <?php if (isset($page_title) && $page_title == 'Booking' && $is_embed == false){echo 'h-100vhs';} ?>">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-xl-8 col-md-10 col-12 card<?php echo ($is_embed?' mribbon-parent':''); ?> shadow-light br-10 <?php if (ckeck_front_plan_limit($user->id, 'appointments', $total) == FALSE){echo 'mt-200';} ?>">


                <?php if(settings()->enable_embed_badge == 1): ?>
                    <?php echo $is_embed?'<h4 class="mribbon"><small>Powered by</small><br/><span>'.settings()->site_name.'<span></h4>':'';?>
                <?php endif; ?>

                <!-- booking form area -->
               
                <?php if (isset($page_title) && $page_title == 'Booking'): ?>
                <?php if($is_embed == true){$action_slug = 'book_embed_appointment';}else{$action_slug = 'book_appointment';} ?>
                    <!-- Form -->
                    <form id="booking_form" method="post" action="<?php echo base_url('company/'.$action_slug.'/'.$slug); ?>">
                    
                        <?php if (ckeck_front_plan_limit($user->id, 'appointments', $total) == FALSE): ?>
                            <div class="booking_step_1s text-center">
                                <p class="pt-4 lead text-muted"><i class="lni lni-ban"></i> <br> <?php echo trans('booking-is-temporary-unavailable') ?></p>
                            </div>
                        <?php else: ?>

                            <div class="mb-4 mt-4 text-center">
                                <div class="success text-success"></div>
                                <div class="success_extend text-success"></div>
                                <div class="error text-danger"></div>
                                <div class="warning text-warning"></div>
                            </div>

                            <div class="booking_step_1 pt-2">
                                <div class="row">

                                    <?php if ($company->enable_location == 1): ?>
                                        <div class="col-md-12 mb-2 text-left">
                                            <h5 class="mb-2 h5"><?php echo trans('locations') ?> </h5>
                                        </div>

                                        <div class="col-md-6" data-aos="fade-up" data-aos-duration="100">
                                            <div class="form-group">
                                              <label class="control-label" for="example-input-normal"><?php echo trans('location') ?> <span class="text-danger">*</span></label>
                                              <select class="form-control custom-select location" name="location_id">
                                                  <option value=""><?php echo trans('select') ?></option>
                                                  <?php foreach ($locations as $location): ?>
                                                      <option value="<?php echo html_escape($location->id); ?>">
                                                        <?php echo html_escape($location->name); ?>
                                                      </option>
                                                  <?php endforeach ?>
                                              </select>

                                              <p class="text-danger fs-14 mt-1 mb-0 d-hide" id="location_error"> <?php echo trans('location-required') ?></p>
                                            </div>
                                        </div>

                                        <div class="col-md-6 sub_area d-hide">
                                            <div class="form-group">
                                              <label class="control-label" for="example-input-normal"><?php echo trans('branches') ?> </label>
                                              <select class="form-control custom-select sub_location" name="sub_location_id" disabled>
                                                  
                                              </select>
                                            </div>
                                        </div>
                                    <?php endif; ?>


                                    <div class="col-md-12 mb-2 mt-0 text-left d-hide">
                                        <h5 class="mb-2 h5"><?php echo trans('select-service') ?> </h5>
                                    </div>

                                    <?php if ($company->enable_category == 1): ?>
                                        <div class="col-md-12">
                                            <div class="service-wrap" data-aos="fade-up">
                                            <?php $c=1; foreach ($categories as $category): ?>

                                                <p class="mb-2 lead fs-15 font-weight-bold"><?php echo html_escape($category->name) ?></p>
                                                
                                                <?php $e=1; foreach ($category->services as $service): ?>
                                                    <label class="service-rdo">
                                                        <input type="radio" name="service_id" class="service_input" value="<?php echo html_escape($service->id) ?>"/>
                                                        <div class="d-flex justify-content-between py-2 align-items-center mb-1 m-0">
                                                            <div class="col-auto mb-sm-0">
                                                                <div class="media service_item">
                                                                    
                                                                    <!-- <?php if (file_exists(FCPATH. $service->image)) {
                                                                        $service_img = base_url($service->image);
                                                                    }else{
                                                                        $service_img = base_url('assets/front/img/no-image.png');
                                                                    } ?> -->

                                                                    <?php if (!empty($service->image)): ?>
                                                                        <img alt="Service" src="<?php echo base_url($service->image) ?>" class="shadow-sm  mr-4">
                                                                    <?php endif ?>

                                                                    <div class="media-body">
                                                                        <h5 class="text-dark mb-0 pt-1 h6"><?php echo html_escape($service->name) ?></h5>
                                                                        <small class="d-block text-dark-75"> <?php echo html_escape($service->duration).' '.trans($service->duration_type); ?> 
                                                                            <span class="mr-2"></span> 
                                                                        </small>

                                                                        <span class="service-price-sm font-weight-bold text-dark d-hide">
                                                                            <?php if ($service->price == 0): ?>
                                                                                <?php echo trans('free') ?>
                                                                            <?php else: ?>
                                                                                <?php if($company->curr_locate == 0){echo get_currency_by_country($company->country)->currency_symbol;} ?> <?php echo number_format($service->price, $company->num_format) ?> <?php if($company->curr_locate == 1){echo get_currency_by_country($company->country)->currency_symbol;} ?>
                                                                            <?php endif ?>
                                                                        </span>

                                                                        <?php if($service->service_type == 2): ?>
                                                                            <span class="mr-3">Recurring service</span>
                                                                            <?php if($service->service_repeat == 7): ?>
                                                                                <span>Repeats Weekly</span>
                                                                            <?php endif; ?>
                                                                            <?php if($service->service_repeat == 30): ?>
                                                                                <span>Repeats Monthly</span>
                                                                            <?php endif; ?>
                                                                        <?php endif; ?>

                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="col-auto text-sm-right">
                                                                <span class="service-price badge badge-secondary-soft badge-pill">
                                                                    <?php if ($service->price == 0): ?>
                                                                        <?php echo trans('free') ?>
                                                                    <?php else: ?>
                                                                        <?php if($company->curr_locate == 0){echo get_currency_by_country($company->country)->currency_symbol;} ?> <?php echo number_format($service->price, $company->num_format) ?> <?php if($company->curr_locate == 1){echo get_currency_by_country($company->country)->currency_symbol;} ?>
                                                                    <?php endif ?>
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </label>


                                                    <div class="service_extra service_extra_area_<?php echo $service->id ?>">

                                                    
                                                    </div>


                                                <?php $e++; endforeach; ?>
                                                
                                            <?php $c++; endforeach; ?>
                                            </div>
                                        </div>
                                    <?php endif ?>
                                    

                                    <?php if ($company->enable_category == 0): ?>
                                    <div class="col-md-12" data-aos="fade-up">
                                        <?php $e=1; foreach ($services as $service): ?>
                                            <label class="service-rdo">
                                                <input type="radio" name="service_id" class="service_input" value="<?php echo html_escape($service->id) ?>"/>
                                                <div class="d-flex justify-content-between py-2 align-items-center mb-4 m-0">
                                                    <div class="col-auto mb-sm-0">
                                                        <div class="media service_item">
                                                            
                                                            <?php if (!empty($service->image)): ?>
                                                                <img alt="Service" src="<?php echo base_url($service->image) ?>" class="shadow-sm  mr-4">
                                                            <?php endif ?>

                                                            <div class="media-body">
                                                                <h5 class="text-dark mb-0 pt-1 h6"><?php echo html_escape($service->name) ?></h5>
                                                                <small class="d-block text-dark-75"> <?php echo html_escape($service->duration).' '.trans($service->duration_type); ?> 
                                                                    <span class="mr-2"></span> 
                                                                </small>

                                                                <span class="service-price-sm font-weight-bold text-dark d-hide">
                                                                    <?php if ($service->price == 0): ?>
                                                                        <?php echo trans('free') ?>
                                                                    <?php else: ?>
                                                                        <?php if($company->curr_locate == 0){echo get_currency_by_country($company->country)->currency_symbol;} ?> <?php echo number_format($service->price, $company->num_format) ?> <?php if($company->curr_locate == 1){echo get_currency_by_country($company->country)->currency_symbol;} ?>
                                                                    <?php endif ?>
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-auto text-sm-right">
                                                        <span class="service-price badge badge-secondary-soft badge-pill">
                                                            <?php if ($service->price == 0): ?>
                                                                <?php echo trans('free') ?>
                                                            <?php else: ?>
                                                                <?php if($company->curr_locate == 0){echo get_currency_by_country($company->country)->currency_symbol;} ?> <?php echo number_format($service->price, $company->num_format) ?> <?php if($company->curr_locate == 1){echo get_currency_by_country($company->country)->currency_symbol;} ?>
                                                            <?php endif ?>
                                                        </span>
                                                    </div>
                                                </div>
                                            </label>

                                            <div class=" service_extra service_extra_area_<?php echo $service->id ?>">
                                                    
                                            </div>
                                            
                                        <?php $e++; endforeach; ?>
                                    </div>
                                    <?php endif ?>

                                </div>
                            

                                <input type="hidden" class="enable_location" value="<?php echo html_escape($company->enable_location); ?>">
                                <input type="hidden" class="enable_staff" value="<?php echo html_escape($company->enable_staff); ?>">
                                <div class="row text-center pt-4 pb-4 <?php if($company->enable_staff == 1){echo "d-show";}else{echo "d-hide";} ?>" id="load_staff_data">
                                    
                                </div>

                                
                                <?php if ($company->default_timezone == 1): ?>
                                    <input type="hidden" class="booking_time_zone" name="time_zone" value="<?php echo $company->time_zone ?>"> 
                                <?php else: ?>
                                
                                <div class="col-md-12 p-0 <?php if(is_customer() && !empty(user()->time_zone)){echo 'd-none';} ?>">
                                    <div class="form-group">
                                        <label><?php echo trans('time-zone') ?><span class="text-danger">*</span></label>
                                        <div class="time_zone_required">
                                            <select class="cus_lh booking_time_zone form-control select2" name="time_zone" style="width: 100%;" >
                                                <option value=""><?php echo trans('select') ?></option>
                                                <?php foreach ($time_zones as $time): ?>
                                                    <option <?php if(is_customer() && user()->time_zone == $time->id){echo 'selected';} ?> value="<?php echo html_escape($time->id); ?>"><?php echo html_escape($time->name); ?>
                                                    </option>
                                                <?php endforeach ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <?php endif ?>


                                <div class="load_input_data"></div>

                                



                                <?php if ($company->enable_group == 1): ?>
                                    <div class="mt-4">
                                        <div class="custom-control custom-switch">
                                            <input type="checkbox" value="1" name="group_booking" class="group_booking custom-control-input" id="switch-2">
                                            <label class="ccb custom-control-label font-weight-bold" for="switch-2"> <?php echo trans('bringing-anyone-with-you') ?> </label>
                                        </div>
                                        <div class="mt-3 person_area dnone">
                                            <div class="form-group mb-4">
                                              <label class="control-label" for="example-input-normal"><?php echo trans('additional-persons') ?></label>
                                              <select class="form-control custom-select" name="total_person">
                                                  <?php for ($i=1; $i <= $company->total_person; $i++) { ?>
                                                    <option value="<?php echo $i ?>"><?php echo $i ?> <?php if($i == 1){echo trans('person');}else{echo trans('persons');} ?></option>
                                                  <?php } ?>
                                              </select>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif ?>


                                <div class="row mt-4">
                                    <div class="col-12 text-center">
                                        <input type="hidden" name="serviceId" class="serviceId" value="">
                                        <button type="button" class="btn btn-secondary btn-block step1_btn" disabled><?php echo trans('continue') ?> <i class="fas fa-long-arrow-alt-right"></i></button>
                                    </div>
                                </div>

                            </div>

                        <?php endif ?>



                        <div class="booking_step_2 dnone">
                            <div class="row">
                                <div class="col-md-<?php if($is_embed == true){echo "12";}else{echo "6";} ?>">
                                    <h5 class="mb-4 h5"><?php echo trans('select-date-time') ?></h5>
                                    <div id="load_work_cal"> 
                                        <div id="datepickers"></div>
                                    </div>
                                </div>

                                <div class="col-md-<?php if($is_embed == true){echo "12 mt-5";}else{echo "6";} ?> p-0 text-center">
                                    <div id="load_data"></div>
                                </div>
                            </div>

                            <div class="row mt-4">
                                <div class="col-12 d-flex justify-content-between">
                                    <input type="hidden" class="booking_date" name="date" value="">
                                    <button type="button" class="btn btn-secondary mr-2 pull-left step2_back_btn"><i class="fas fa-long-arrow-alt-left"></i> <?php echo trans('back') ?> </button>
                                    <button type="button" class="btn btn-primary step2_btn" disabled><?php echo trans('continue') ?> <i class="fas fa-long-arrow-alt-right"></i></button>
                                </div>
                            </div>
                        </div>
                        
                        

                        <div class="booking_step_3 dnone">
                            
                            <?php if(!is_customer()): ?>
                                <ul class="nav nav-pills mb-3 mb-3 mt-4 justify-content-center" id="pills-tab" role="tablist">
                                    <li class="nav-item mr-2 mb-4">
                                        <a class="booking-nav-item nav-link active click_new" id="one-tab" data-toggle="pill" href="#one" role="tab" aria-controls="One" aria-selected="true"><i class="fas fa-user-plus"></i> <?php echo trans('new-registration') ?></a>
                                    </li>
                                    <li class="nav-item mr-2 mb-4">
                                        <a class="booking-nav-item nav-link click_old" id="two-tab" data-toggle="pill" href="#two" role="tab" aria-controls="two" aria-selected="false"><i class="fas fa-user-check"></i> <?php echo trans('already-have-account') ?></a>
                                    </li>

                                    <?php if ($company->enable_guest == 1): ?>
                                    <li class="nav-item mr-2 mb-4">
                                        <a class="booking-nav-item nav-link click_guest" id="one-tab" data-toggle="pill" href="#one" role="tab" aria-controls="one" aria-selected="false"><i class="fas fa-user-secret"></i> <?php echo trans('guest-booking') ?></a>
                                    </li>
                                    <?php endif ?>

                                </ul>
                            
                                <div class="tab-content" id="myTabContent">
                                    <div class="tab-pane fade show active mt-6" id="one" role="tabpanel" aria-labelledby="one-tab">
                                        <div class="row p-0">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label><?php echo trans('name') ?></label>
                                                    <input type="text" class="form-control" name="name" placeholder="<?php echo trans('your-full-name') ?>">
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-12">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlSelect1"><?php echo trans('phone') ?> <span class="text-danger">*</span></label>
                                                            <div class="input-phone"></div>
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>

                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label><?php echo trans('email') ?> <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="email" placeholder="<?php echo trans('your-email-address') ?>">
                                                </div>
                                            </div>

                                            <div class="col-md-12 guest_hide">
                                                <div class="form-group mb-5">
                                                    <label><?php echo trans('password') ?> <span class="text-danger">*</span></label>
                                                    <input type="password" class="form-control" name="new_password" placeholder="<?php echo trans('your-password') ?>">
                                                </div>
                                            </div>
                                            
                                        </div>
                                    </div>

                                    <div class="tab-pane fade show mt-6" id="two" role="tabpanel" aria-labelledby="two-tab">
                                        <div class="row p-0">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label><?php echo trans('phone') ?> / <?php echo trans('email') ?></label>
                                                    <input type="text" class="form-control" name="user_name" placeholder="<?php echo trans('your-email') ?>">
                                                </div>
                                            </div>

                                            <div class="col-md-12">
                                                <div class="form-group mb-5">
                                                    <label><?php echo trans('password') ?></label>
                                                    <input type="password" class="form-control" name="old_password" placeholder="<?php echo trans('your-password') ?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            <?php endif; ?>

                            <div class="row mt-2">

                                    <div class="col-12 mb-4">
                                        <a href="javascript:;" class="fs-15 mb-2 badge badge-secondary-soft badge-pill note_btn"><?php echo trans('any-special-notes') ?></a>
                                        <textarea class="form-control mt-2 note_area d-hide" name="note" rows="2" placeholder="<?php echo trans('write-your-notes-here') ?>"></textarea>
                                    </div>

                                    <div class="col-12 mb-4">
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" name="booking_terms_btn" class="custom-control-input booking_terms_btn"
                                                id="terms-condition" required>
                                            <label class="custom-control-label" for="terms-condition">
                                                <?php echo trans('i-have-read-and-understood-the') ?> 
                                                <a href="<?php echo base_url('terms-and-conditions/'.$company->slug) ?>"><?php echo trans('terms-and-conditions') ?></a>
                                                <?php echo trans('and') ?> <a href="<?php echo base_url('privacy-policy/'.$company->slug) ?>"> <?php echo trans('privacy-policy') ?> </a><?php echo trans('of-this-site') ?>.</label>
                                        </div>
                                    </div>
                                
                                    <div class="col-12">
                                        <?php if (settings()->enable_captcha == 1 && settings()->captcha_site_key != ''): ?>
                                            <div class="g-recaptcha pull-left" data-sitekey="<?php echo html_escape(settings()->captcha_site_key); ?>"></div>
                                        <?php endif ?>
                                    </div>

                                    <!-- csrf token -->
                                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">

                                    <input type="hidden" class="is_customer_exist" name="is_customer_exist" value="<?php if(is_customer()){echo 1;}else{echo 0;} ?>">

                                    <div class="col-12 d-flex justify-content-between">
                                        <button type="button" class="btn btn-secondary step3_back_btn"><i class="fas fa-long-arrow-alt-left"></i> <?php echo trans('back') ?> </button>
                                        <button type="submit" class="btn btn-primary step3_btn" disabled="disabled"><?php echo trans('continue') ?> <i class="fas fa-long-arrow-alt-right"></i></button>
                                    </div>
                                </div>
                                
                            </div>
                        </div>

                    </form>
                    <!-- End Form -->
                <?php endif; ?>






                <!-- booking confirm area -->
                <?php if (isset($page_title) && $page_title == 'Booking Confirm'): ?>
                    <div class="booking_confirm">
                        <div class="row" data-aos="fade-up" data-aos-duration="150">
                            <div class="col-md-6">
                                <p class="mb-0"><?php echo trans('booking-number') ?> </p>
                                <h4># <?php echo html_escape($appointment->number) ?></h4>
                            </div>

                            <div class="col-md-6 text-right">
                                <?php if ($is_embed == false): ?>
                                    <?php if (!empty(settings()->google_client_id) && !empty(settings()->google_client_secret)): ?>
                                        <?php if (check_user_feature_access($appointment->user_id, 'google-calendar-sync') == TRUE): ?>
                                            <?php if ($appointment->sync_calendar != 1): ?>
                                                <a target="_blank" href="<?php echo base_url('googlecalendar/login') ?>" class="btn btn-danger btn-sm mt-3"><i class="fas fa-calendar-check"></i> <?php echo trans('sync-google-calendar') ?></a>
                                            <?php endif ?>
                                        <?php endif ?>
                                    <?php endif ?>
                                <?php endif ?>
                            </div>
                        </div>
                    
                        <div class="row mt-4" data-aos="fade-up" data-aos-duration="250">
                            <div class="col-md-12 mb-2 text-left">
                                <h5 class="mb-2 h5 info-title"><?php echo trans('booking-info') ?></h5>
                            </div>
                            
                            <div class="col-md-6 mb-2 text-left">
                                <p class="small mb-0"><i class="fas fa-calendar-alt"></i> <?php echo trans('date') ?></p>
                                <p class="text-dark font-weight-normal"> <?php echo my_date_show($appointment->date) ?></p>
                            </div>
                
                            <div class="col-md-6 mb-2 text-left">
                                <?php if ($appointment->duration_type != 'day'): ?>
                                <p class="small mb-0"><i class="far fa-clock"></i> <?php echo trans('time') ?></p>
                                <p class="text-dark font-weight-normal"> <?php echo format_time($convert_time, $company->time_format) ?></p>    
                                <?php endif ?>
                            </div>

                            <div class="col-md-6 mb-2 text-left">
                                <p class="small mb-0"><i class="fas fa-layer-group"></i> <?php echo trans('service') ?></p>
                                <p class="text-dark font-weight-normal"><?php echo html_escape($appointment->service_name) ?></p>
                            </div>

                            <div class="col-md-6 mb-2 text-left">
                                <?php if (!empty($appointment->staff_name)): ?>
                                    <p class="small mb-0"><i class="fas fa-user"></i> <?php echo trans('staff') ?></p>
                                    <p class="text-dark font-weight-normal"><?php echo html_escape($appointment->staff_name) ?></p>
                                <?php endif ?>
                            </div>

                            <?php if(!empty($appointment->service_extra)): ?>
                                <?php 
                                    $extras = $appointment->service_extra ;
                                    $extras = explode(',', $extras);
                                ?>
                                <div class="col-md-12 mb-2 text-left">
                                    <p class="small mb-0"><i class="fas fa-plus-circle"></i> <?php echo trans('extra-service') ?></p>
                                    <?php foreach ($extras as $extra): ?>
                                        <p class="text-dark font-weight-normal mb-0">
                                           <i class="bi bi-arrow-right fs-12"></i> <?php echo get_by_id($extra,'service_extra')->name ?>
                                           (<b><?php echo get_by_id($extra,'service_extra')->duration ?> <?php echo trans(get_by_id($extra,'service_extra')->duration_type) ?></b>)
                                        </p>
                                    <?php endforeach ?>
                                </div>
                            <?php endif; ?>

                            <?php if ($appointment->group_booking != 0): ?>
                                <div class="col-md-6 mb-2 text-left">
                                    <p class="small mb-0"><?php echo trans('group-booking') ?></p>
                                    <p class="text-dark font-weight-normal"><?php echo trans('yes') ?></p>
                                </div>

                                <div class="col-md-6 mb-2 text-left">
                                    <?php if (!empty($appointment->staff_name)): ?>
                                        <p class="small mb-0"><?php echo trans('additional-persons') ?></p>
                                        <p class="text-dark font-weight-normal"><?php echo html_escape($appointment->total_person) ?></p>
                                    <?php endif ?>
                                </div>
                            <?php endif ?>
                        </div>

                        <div class="row mt-4" data-aos="fade-up" data-aos-duration="400">
                            <div class="col-md-12 mb-2 text-left">
                                <h5 class="mb-2 h5 info-title"><?php echo trans('customer-info') ?></h5>
                            </div>
                            
                            <div class="col-md-6 mb-2 text-left">
                                <p class="small mb-0"><?php echo trans('name') ?></p>
                                <p class="text-dark font-weight-bold"><?php echo html_escape($appointment->customer_name) ?></p>
                            </div>

                            <div class="col-md-6 mb-2 text-left">
                                <p class="small mb-0"><?php echo trans('email') ?></p>
                                <p class="text-dark font-weight-bold"><?php echo html_escape($appointment->customer_email) ?></p>
                            </div>
                        </div>
                        
                        <div class="row mt-4" data-aos="fade-up" data-aos-duration="550">
                            <div class="col-md-12 mb-2 text-left">
                                <h5 class="mb-2 h5 info-title"><?php echo trans('payment-info') ?></h5>
                            </div>


                            <!-- coupons section -->
                            <?php include APPPATH.'views/include/coupon_section.php'; ?>

                            <!-- regular booking confirmation -->
                            <?php if ($is_embed == false): ?>
                                
                                <?php if (settings()->enable_wallet == 0): ?>
                                
                                    <?php if (check_user_feature_access($company->user_id, 'get-online-payments') == TRUE && $appointment->price != 0 && get_user_info() == TRUE): ?>
                                        <div class="col-md-6 mb-2 text-left <?php if($company->enable_payment == 1){echo "d-show";}else{echo "d-hide";} ?>">
                                            <label class="staff-rdo bg-primary-soft">
                                                <input type="radio" name="pay_info" class="pay_info" value="1" />
                                                <div class="bg-lights py-4 rounded-sm text-center payment_option">
                                                    <i class="far fa-credit-card fa-2x text-muted"></i>
                                                    <h6 class="mb-0 mt-2 text-dark-45 text-muted"><?php echo trans('pay-now') ?></h6>
                                                </div>
                                            </label>
                                        </div>
                                    <?php endif ?>

                                <?php else: ?>

                                    <div class="col-md-6 mb-2 text-left <?php if($company->enable_payment == 1){echo "d-show";}else{echo "d-hide";} ?>">
                                        <label class="staff-rdo bg-primary-soft">
                                            <input type="radio" name="pay_info" class="pay_info" value="1" />
                                            <div class="bg-lights py-4 rounded-sm text-center payment_option">
                                                <i class="far fa-credit-card fa-2x text-muted"></i>
                                                <h6 class="mb-0 mt-2 text-dark-45 text-muted"><?php echo trans('pay-now') ?></h6>
                                            </div>
                                        </label>
                                    </div>

                                <?php endif ?>
                                
                                <?php $number = $appointment->number; ?>
                            
                                <?php $can_display_payment = check_if_display_payment($number, 'appointments'); ?>

                                <?php if ($can_display_payment && $appointment->price != 0): ?>
                                <div class="col-md-6 mb-2 text-left <?php if($company->enable_onsite == 1){echo "d-show";}else{echo "d-hide";} ?>">
                                    <label class="staff-rdo bg-primary-soft">
                                        <input type="radio" name="pay_info" class="pay_info" value="2" />
                                        <div class="bg-lights py-4 rounded-sm text-center payment_option">
                                            <i class="far fa-clock fa-2x text-muted"></i>
                                            <h6 class="mb-0 mt-2 text-dark-45 text-muted"><?php echo trans('pay-on-site') ?></h6>
                                        </div>
                                    </label>
                                </div>
                                 <!-- 新增的綠界支付按鈕 -->
                            <div class="col-md-6 mb-2 text-left d-show payment-section" id="ecpay_button">
                                <label class="staff-rdo bg-primary-soft">
                                    <input type="radio" name="pay_info" class="pay_info" value="2" />
                                    <div class="bg-lights py-4 rounded-sm text-center payment_option" onclick="redirectToECPay()">
                                        <i class="fas fa-credit-card fa-2x text-muted"></i>
                                        <h6 class="mb-0 mt-2 text-dark-45 text-muted"><?php echo trans('ec-pay') ?></h6>
                                    </div>
                                </label>
                            </div>
                             <!-- 新增的 Line Pay 按鈕 -->
                            <div class="col-md-6 mb-2 text-left d-show payment-section" id="linepay_button">
                                <label class="staff-rdo bg-primary-soft">
                                    <input type="radio" name="pay_info" class="event_pay_info" value="4" />
                                    <div class="bg-lights py-4 rounded-sm text-center payment_option" onclick="redirectToLinePay()">
                                        <i class="fab fa-line fa-2x text-muted"></i>
                                        <h6 class="mb-0 mt-2 text-dark-45 text-muted"><?php echo trans('line-pay') ?></h6>
                                    </div>
                                </label>
                            </div>
                                <?php endif; ?>

                                

                                <!-- load payment gateways -->
                                <div class="col-md-12 mt-4 payments_area dnone">
                                    <?php if (settings()->enable_wallet == 1): ?>
                                        <?php $this->load->view('include/payment_section_admin.php');?>
                                    <?php else: ?>
                                        <?php $this->load->view('include/payment_section.php');?>
                                    <?php endif ?>
                                </div>
                                

                                
                                <!-- confirm booking button -->
                                <div class="col-md-12 mt-4 confirm_area <?php if ($appointment->price != 0){echo "dnone";} ?>">
                                    <button type="button" data-id="<?php echo html_escape($appointment->id) ?>" data-val="<?php echo html_escape($slug) ?>" class="btn btn-primary btn-block confirm_pay_info"><i class="fas fa-check-circle"></i> <?php echo trans('confirm-booking') ?> </button>
                                </div>

                            <?php endif ?>

                            <!-- embed booking confirmation -->
                            <?php if ($is_embed == true): ?>
                                <?php
                                    if (settings()->enable_wallet == 1) {
                                        $emb_booking_val = 1;
                                    }else{
                                        if ($company->enable_payment == 1) {
                                            $emb_booking_val = 1;
                                        }else{
                                            $emb_booking_val = 2;
                                        }
                                    }
                                ?>
                                <input type="hidden" name="emb_booking_info" class="emb_booking_info" value="<?php echo $emb_booking_val; ?>">
                                <!-- confirm booking button -->
                                <div class="col-md-12 mt-4 confirm_area">
                                <button type="button" data-id="<?php echo html_escape($appointment->id) ?>" data-val="<?php echo html_escape($slug) ?>" class="btn btn-primary btn-block confirm_embed_pay"><i class="fas fa-check-circle"></i> <?php echo trans('confirm-booking') ?></button>
                            <?php endif ?>
                        <?php
                        // 取得目前頁面完整網址
                        $current_url = current_url();

                        // 簡訊內容，帶入動態網址
                        $sms_content = "【知萌職能語言聯合所】您好，本次服務已完成，請至 {$current_url} 付款。如有疑問請聯絡診所，祝您健康快樂！";

                        // 手機號碼格式清理函式
                        function clean_phone_number($phone)
                        {
                            // 移除「+」、空格、「.」、「-」
                            $phone = str_replace(['+', ' ', '.', '-'], '', $phone);

                            if (strpos($phone, '886') === 0) {
                                $phone = '0' . substr($phone, 4);
                            }

                            // 如果號碼開頭為 88609，改為 8869
                            if (strpos($phone, '88609') === 0) {
                                $phone = '8869' . substr($phone, 5);
                            }

                            return $phone;
                        }

                        // 發送簡訊函式
                        function send_sms($username, $password, $dstaddr, $smbody, $scheduled_time, $vldtime = null)
                        {
                            $url = "https://smsapi.mitake.com.tw/api/mtk/SmSend?CharsetURL=UTF8"; // 三竹網域名稱
                            $data = [
                                'username' => $username,
                                'password' => $password,
                                'dstaddr'  => $dstaddr,        // 接收者手機號碼
                                'smbody'   => $smbody, // URL Encode 簡訊內容
                                'dlvtime'  => $scheduled_time, // 簡訊預約時間
                                'vldtime'  => $vldtime,        // 簡訊有效期限 (非必要可省略)
                            ];

                            // 初始化 CURL
                            $ch = curl_init();
                            curl_setopt($ch, CURLOPT_URL, $url); // 明確指定 URL
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($ch, CURLOPT_POST, true);
                            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));

                            // 設定 Header
                            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                                "Content-type: application/x-www-form-urlencoded"
                            ]);
                            curl_setopt($ch, CURLOPT_HEADER, 0);

                            // 發送請求並獲取回應
                            $response = curl_exec($ch);

                            // 如果發生錯誤，記錄錯誤訊息
                            if (curl_errno($ch)) {
                                $error_msg = curl_error($ch);
                                echo "<p class='text-danger'>CURL Error: {$error_msg}</p>";
                            }

                            curl_close($ch);

                            return $response;
                        }

                        $number = $appointment->number;

                        // 取得客戶電話號碼並進行格式清理
                        if (empty($appointment->is_sent_sms) || $appointment->is_sent_sms == 0) {
                            $customer_id = $appointment->customer_id;
                            $register = $this->common_model->get_by_id($customer_id, 'customers');

                            $cleaned_phone = clean_phone_number($register->phone);

                            // 簡訊有效期限 (24小時後過期)
                            $valid_time = date('YmdHis', strtotime('+24 hours'));

                            // 預約發送時間 (進入頁面時間 + 45 分鐘，格式為 YYYYMMDDHHMMSS)
                            $scheduled_time = date('YmdHis', strtotime('+45 minutes'));

                            // 三竹簡訊帳號與密碼 (請替換為實際帳號與密碼)
                            $sms_username = "93757326SMS";
                            $sms_password = "Aa93757326";

                            // 發送簡訊
                            $sms_response = send_sms($sms_username, $sms_password, $cleaned_phone, $sms_content, $scheduled_time, $valid_time);

                        // 簡訊發送狀態處理
                        if ($sms_response) {
                            echo "<p class='text-success'>【知萌職能語言聯合所】感謝您的光臨，本次服務已完成，請至付款。如有疑問請聯絡診所，祝您健康快樂！</p>";

                             // 更新資料庫，設置 is_sent_sms = 1
                             $this->db->where('number', $number)->update('appointments', ['is_sent_sms' => 1]);
                        } else {
                            echo "<p class='text-danger'>簡訊發送失敗，請檢查手機設定。</p>";
                        }
                      } else {
                            echo "<p class='text-info'>簡訊已發送過，此次不重複發送。</p>";
                        }
                        ?>
                    </div>
                <?php endif ?>
            <script>
                function redirectToECPay() {
                    const ecpayUrl = "<?php echo base_url('ecpay.php'); ?>"; // 後端處理程式的 URL

                    // 建立表單
                    const form = document.createElement('form');
                    form.method = 'POST';
                    form.action = ecpayUrl;

                    const order_id = '<?php echo $appointment->number; ?>'; // 確保正確引入變數
                    let amount = '<?php echo number_format(get_appointment_price($appointment, $company), $company->num_format) ?>'; // 確保正確取得金額
                    amount = amount.replace(/,/g, ''); // 去除逗號
                    amount = parseFloat(amount); // 將字串轉為數字
                    const staff_name = '<?php echo $appointment->service_name; ?>'; // 避免 JS injection

                    // 動態新增參數
                    const params = {
                        MerchantTradeNo: order_id, // 商店代碼
                        TotalAmount: amount, // 動態總金額
                        ItemName: staff_name // 商品名稱
                    };

                    for (const key in params) {
                        if (params.hasOwnProperty(key)) {
                            const hiddenField = document.createElement('input');
                            hiddenField.type = 'hidden';
                            hiddenField.name = key;
                            hiddenField.value = params[key];
                            form.appendChild(hiddenField);
                        }
                    }

                    // 將表單加入頁面並提交
                    document.body.appendChild(form);
                    form.submit();
                }
                
                function redirectToLinePay() {
                    const linepayUrl = "<?php echo base_url('linepay.php'); ?>"; // 後端處理程式的 URL
                    const form = document.createElement('form');
                    form.method = 'POST';
                    form.action = linepayUrl;



                    const order_id = '<?php echo $appointment->number; ?>'; // 確保正確引入變數
                    const amount = '<?php echo $service->price; ?>'; // 確保正確取得金額
                    const staff_name = '<?php echo $appointment->service_name; ?>'; // 避免 JS injection

                    form.innerHTML = `
                        <input type="hidden" name="order_id" value="${order_id}">
                        <input type="hidden" name="amount" value="${amount}">
                        <input type="hidden" name="staff_name" value="${staff_name}">
                    `;
                    document.body.appendChild(form);
                    form.submit();
                }
                
            </script>

    
     
            </div>        </div>
    </div>
</section>