<?php
// ECPay 必填參數
$merchantID = '2000132'; // 測試商店代號
$hashKey = '5294y06JbISpM5x9'; // 測試 HashKey
$hashIV = 'v77hoKGq4kWxNNIS'; // 測試 HashIV
$orderID = $_POST['order_id']; // 從前端接收訂單編號
$totalAmount = 1000; // 總金額（測試用）
$returnURL = 'https://aoxio.kayle.io/return.php'; // 綠界通知 API
$clientBackURL = 'https://aoxio.kayle.io/back.php'; // 用戶返回網址

// 設定參數
$params = [
    'MerchantID' => $merchantID,
    'MerchantTradeNo' => $orderID,
    'MerchantTradeDate' => date('Y/m/d H:i:s'),
    'PaymentType' => 'aio',
    'TotalAmount' => $totalAmount,
    'TradeDesc' => urlencode('測試交易描述'),
    'ItemName' => urlencode('測試商品 x1'),
    'ReturnURL' => $returnURL,
    'ClientBackURL' => $clientBackURL,
    'ChoosePayment' => 'ALL',
];

// 生成檢查碼
ksort($params);
$checkString = 'HashKey=' . $hashKey;
foreach ($params as $key => $value) {
    $checkString .= '&' . $key . '=' . $value;
}
$checkString .= '&HashIV=' . $hashIV;
$params['CheckMacValue'] = strtoupper(md5(strtolower(urlencode($checkString))));

// 生成綠界表單，並自動提交
echo '<form id="ecpay-form" method="POST" action="https://payment-stage.ecpay.com.tw/Cashier/AioCheckOut/V5">';
foreach ($params as $key => $value) {
    echo '<input type="hidden" name="' . $key . '" value="' . $value . '">';
}
echo '</form>';
echo '<script>document.getElementById("ecpay-form").submit();</script>';
?>

