/*!
 * Author - Codericks
 */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (global = global || self, factory(global.adminlte = {}));
}(this, (function (exports) { 'use strict';


    var loading_html = '<div class="container text-center" style="padding: 200px"><div class="spinner-md"></div></div>';
    var base_url = $('#base_url').val();
    var success = $('#success').val();
    var error = $('#error').val();
    var lc = $('#lc').val();

    var msg_opps = $('.msg_opps').val();
    var msg_error = $('.msg_error').val();
    var msg_success = $('.msg_success').val();
    var msg_sorry = $('.msg_sorry').val();
    var msg_yes = $('.msg_yes').val();
    var msg_cancel = $('.msg_cancel').val();
    var msg_congratulations = $('.msg_congratulations').val();
    var msg_something_wrong = $('.msg_something_wrong').val();
    var msg_try_again = $('.msg_try_again').val();
    var msg_password_reset_success_msg = $('.msg_password_reset_success_msg').val();
    var msg_confirm_pass_not_match_msg = $('.msg_confirm_pass_not_match_msg').val();
    var msg_old_password_doesnt_match = $('.msg_old_password_doesnt_match').val();
    var msg_inserted = $('.msg_inserted').val();
    var msg_made_changes_not_saved = $('.msg_made_changes_not_saved').val();
    var msg_no_data_founds = $('.msg_no_data_founds').val();
    var msg_del_success = $('.msg_del_success').val();
    var msg_account_suspend_msg = $('.msg_account_suspend_msg').val();
    var msg_are_you_sure = $('.msg_are_you_sure').val();
    var msg_get_started = $('.msg_get_started').val();
    var msg_not_recover_file = $('.msg_not_recover_file').val();
    var msg_deleted_successfully = $('.msg_deleted_successfully').val();
    var msg_data_limit_over = $('.msg_data_limit_over').val();
    var msg_email_exist = $('.msg_email_exist').val();
    var msg_recaptcha_is_required = $('.msg_recaptcha_is_required').val();
    var msg_not_active = $('.msg_not_active').val();
    var msg_signin = $('.msg_signin').val();
    var msg_signing_in = $('.msg_signing_in').val();
    var msg_wrong_access = $('.msg_wrong_access').val();
    var msg_email_not_verified = $('.msg_email_not_verified').val();
    var msg_pass_sent_email = $('.msg_pass_sent_email').val();
    var msg_pass_reset_succ = $('.msg_pass_reset_succ').val();
    var msg_not_valid_user = $('.msg_not_valid_user').val();

    var msg_apptype_is_required = $('.msg_apptype_is_required').val();
    var msg_booking_date_required = $('.msg_booking_date_required').val();
    var msg_booking_time_required = $('.msg_booking_time_required').val();
    var msg_processing = $('.msg_processing').val();
    var msg_app_booked_successfully = $('.msg_app_booked_successfully').val();
    var msg_book_appointment = $('.msg_book_appointment').val();
    var msg_enter_valid_date = $('.msg_enter_valid_date').val();
    var msg_registared_successfully = $('.msg_registared_successfully').val();
    var msg_preparing_environment = $('.msg_preparing_environment').val();
    var msg_email_resend_successfully = $('.msg_email_resend_successfully').val();
    var msg_signing_in = $('.msg_signing_in').val();
    var msg_register = $('.msg_register').val();
    var msg_your_accoun_verified_successfully = $('.msg_your_accoun_verified_successfully').val();
    var msg_verify_code_is_not_matched = $('.msg_verify_code_is_not_matched').val();

    var msg_cancel_appointment = $('.msg_cancel_appointment').val();
    var msg_cancel_success = $('.msg_cancel_success').val();
    var msg_sms_notify = $('.msg_sms_notify').val();
    var msg_send_success = $('.msg_send_success').val();
    var msg_start_time = $('.msg_start_time').val();
    var msg_end_time = $('.msg_end_time').val();
  


    $(document).ready(function(){

      $('.iconpicker').iconpicker({
        // customize the icon picker with the following options
        // THANKS FOR WATCHING!
        title: 'My Icon Picker',
        selected: false,
        defaultValue: false,
        placement: "bottom",
        collision: "none",
        animation: true,
        hideOnSelect: true,
        showFooter: true,
        searchInFooter: false,
        mustAccept: false,
        selectedCustomClass: "bg-primary",
        fullClassFormatter: function (e) {
            return e;
        },
        input: "input,.iconpicker-input",
        inputSearch: false,
        container: false,
        component: ".input-group-addon,.iconpicker-component",
        templates: {
            popover: '<div class="iconpicker-popover popover" role="tooltip"><div class="arrow"></div>' + '<div class="popover-title"></div><div class="popover-content"></div></div>',
            footer: '<div class="popover-footer"></div>',
            buttons: '<button class="iconpicker-btn iconpicker-btn-cancel btn btn-default btn-sm">Cancel</button>' + ' <button class="iconpicker-btn iconpicker-btn-accept btn btn-primary btn-sm">Accept</button>',
            search: '<input type="search" class="form-control iconpicker-search" placeholder="Type to filter" />',
            iconpicker: '<div class="iconpicker"><div class="iconpicker-items"></div></div>',
            iconpickerItem: '<a role="button" href="javascript:;" class="iconpicker-item"><i></i></a>'
        }
    });


      /* copy embedded code to clipboard */
      function mhtmlspecialchars_decode (string, quoteStyle) { // eslint-disable-line camelcase
        //       discuss at: https://locutus.io/php/htmlspecialchars_decode/
        //      original by: Mirek Slugen
        //      improved by: Kevin van Zonneveld (https://kvz.io)
        //      bugfixed by: Mateusz "loonquawl" Zalega
        //      bugfixed by: Onno Marsman (https://twitter.com/onnomarsman)
        //      bugfixed by: Brett Zamir (https://brett-zamir.me)
        //      bugfixed by: Brett Zamir (https://brett-zamir.me)
        //         input by: ReverseSyntax
        //         input by: Slawomir Kaniecki
        //         input by: Scott Cariss
        //         input by: Francois
        //         input by: Ratheous
        //         input by: Mailfaker (https://www.weedem.fr/)
        //       revised by: Kevin van Zonneveld (https://kvz.io)
        // reimplemented by: Brett Zamir (https://brett-zamir.me)
        //        example 1: htmlspecialchars_decode("<p>this -&gt; &quot;</p>", 'ENT_NOQUOTES')
        //        returns 1: '<p>this -> &quot;</p>'
        //        example 2: htmlspecialchars_decode("&amp;quot;")
        //        returns 2: '&quot;'
        let optTemp = 0
        let i = 0
        let noquotes = false
        if (typeof quoteStyle === 'undefined') {
          quoteStyle = 2
        }
        string = string.toString()
          .replace(/&lt;/g, '<')
          .replace(/&gt;/g, '>')
        const OPTS = {
          ENT_NOQUOTES: 0,
          ENT_HTML_QUOTE_SINGLE: 1,
          ENT_HTML_QUOTE_DOUBLE: 2,
          ENT_COMPAT: 2,
          ENT_QUOTES: 3,
          ENT_IGNORE: 4
        }
        if (quoteStyle === 0) {
          noquotes = true
        }
        if (typeof quoteStyle !== 'number') {
          // Allow for a single string or an array of string flags
          quoteStyle = [].concat(quoteStyle)
          for (i = 0; i < quoteStyle.length; i++) {
            // Resolve string input to bitwise e.g. 'PATHINFO_EXTENSION' becomes 4
            if (OPTS[quoteStyle[i]] === 0) {
              noquotes = true
            } else if (OPTS[quoteStyle[i]]) {
              optTemp = optTemp | OPTS[quoteStyle[i]]
            }
          }
          quoteStyle = optTemp
        }
        if (quoteStyle & OPTS.ENT_HTML_QUOTE_SINGLE) {
          // PHP doesn't currently escape if more than one 0, but it should:
          string = string.replace(/&#0*39;/g, "'")
          // This would also be useful here, but not a part of PHP:
          // string = string.replace(/&apos;|&#x0*27;/g, "'");
        }
        if (!noquotes) {
          string = string.replace(/&quot;/g, '"')
        }
        // Put this in last place to avoid escape being double-decoded
        string = string.replace(/&amp;/g, '&')
        return string
      }

      $(document).on('click', '.btn-clipboard', function(){
        const codeId = $(this).attr('data-id');
        if(codeId !== undefined && codeId.length > 0){
          const codeContainer = document.getElementById(codeId);
          if(codeContainer !==undefined){
            /* Select the text field */
            // codeContainer.select();
            // codeContainer.setSelectionRange(0, 99999); /* For mobile devices */
            /* Copy the text inside the text field */
            navigator.clipboard.writeText(mhtmlspecialchars_decode(codeContainer.innerHTML));
            $(this).attr('data-title',$(this).attr('title'));
            $(this).attr('title',$(this).attr('data-title2'));
            $(this).removeAttr('data-title2');
            $(this).html('<i class="far fa-clone"></i> '+$(this).attr('title'));
            window.setTimeout(()=>{
              $(this).attr('data-title2',$(this).attr('title'));
              $(this).attr('title',$(this).attr('data-title'));
              $(this).removeAttr('data-title');
              $(this).html('<i class="far fa-clone"></i> '+$(this).attr('title'));
            },1000)

          }
        }
      })

      $(document).on('click', '.btn-clipboard2', function(){
        $('.btn-clipboard').click();
      })
      /* end of copy embedded code to clipboard */


      
      // Initialize the clipboard instance
      var clipboard = new ClipboardJS('.copy_button', {
        target: function() {
          return document.querySelector('.copy_url');
        }
      });
      clipboard.on('success', function(e) {
          $("#successMsg").html('Copied text to clipboard!').delay(3000).slideUp('slow');

        e.clearSelection();
      });


      $(document).on('change', ".show_method", function() {
          $('.method_details').slideDown();
      });

      $(document).on('click', ".get_user", function() {
        $('.create_user').removeClass('active');
        $('.update_user').removeClass('active');
        $('.delete_user').removeClass('active');
        $('.login_user').removeClass('active');

        $(this).addClass('active');
        $('.get_user_area').show();
        $('.api_area').show();
        $('.create_user_area').hide();
        $('.update_user_area').hide();
        $('.delete_user_area').hide();
        $('.login_area').hide();
      });

      $(document).on('click', ".create_user", function() {
        $('.get_user').removeClass('active');
        $('.update_user').removeClass('active');
        $('.delete_user').removeClass('active');
        $('.login_user').removeClass('active');

        $(this).addClass('active');
        $('.api_area').show();
        $('.create_user_area').show();
        $('.get_user_area').hide();
        $('.update_user_area').hide();
        $('.delete_user_area').hide();
        $('.login_area').hide();
      });

      $(document).on('click', ".update_user", function() {
        $('.get_user').removeClass('active');
        $('.create_user').removeClass('active');
        $('.delete_user').removeClass('active');
        $('.login_user').removeClass('active');

        $(this).addClass('active');
        $('.get_user_area').hide();
        $('.api_area').show();
        $('.create_user_area').hide();
        $('.update_user_area').show();
        $('.delete_user_area').hide();
        $('.login_area').hide();
      });

      $(document).on('click', ".delete_user", function() {
        $('.get_user').removeClass('active');
        $('.create_user').removeClass('active');
        $('.update_user').removeClass('active');
        $('.login_user').removeClass('active');

        $(this).addClass('active');
        $('.get_user_area').hide();
        $('.api_area').show();
        $('.create_user_area').hide();
        $('.update_user_area').hide();
        $('.delete_user_area').show();
        $('.login_area').hide();
      });

      $(document).on('click', ".login_user", function() {
        $('.get_user').removeClass('active');
        $('.create_user').removeClass('active');
        $('.update_user').removeClass('active');
        $('.delete_user').removeClass('active');
        
        $(this).addClass('active');
        $('.get_user_area').hide();
        $('.api_area').show();
        $('.create_user_area').hide();
        $('.update_user_area').hide();
        $('.delete_user_area').hide();
        $('.login_area').show();
      });

  
      
      $('#summernote').summernote({
        toolbar: [
          // [groupName, [list of button]]
          ['style', ['bold', 'italic', 'underline', 'clear']],
          ['font', ['strikethrough', 'superscript', 'subscript']],
          ['fontsize', ['fontsize']],
          ['color', ['color']],
          ['para', ['ul', 'ol', 'paragraph']],
          ['height', ['height']],
          ['insert', ['link']],
          ['view', ['codeview']],
        ]
      });

      $('.summernote').summernote({
        toolbar: [
          // [groupName, [list of button]]
          ['style', ['bold', 'italic', 'underline', 'clear']],
          ['font', ['strikethrough', 'superscript', 'subscript']],
          ['fontsize', ['fontsize']],
          ['color', ['color']],
          ['para', ['ul', 'ol', 'paragraph']],
          ['height', ['height']],
          ['insert', ['link']],
          ['view', ['codeview']],
        ]
      });

      !function(window, document, $) {
      "use strict";
        $("input,select,textarea").not("[type=submit]").jqBootstrapValidation();
    }(window, document, jQuery);
      
      bsCustomFileInput.init();
      
      $(".datatable").DataTable();

      AOS.init();

      

      if ($('#success').val()) {
        tata.success(msg_success, success, {
          position: 'tr',
          duration: 3000,
          animate: 'slide'
        });
      }
      
      if ($('#error').val()) {
        tata.error(msg_error, error, {
          position: 'tr',
          duration: 6000,
          animate: 'slide'
        });
      }
    
      //Initialize datepicker elements
      // jQuery('.datepicker').datepicker({
      //     format: 'yyyy-mm-dd'
      // });
  
      //Initialize select2 elements
      $('.select2').select2();
      //Initialize nice select elements
      $('.nice_select').niceSelect();
      40!=lc&&$(".wrapper").hide();

    });
  

    $(document).on('change', ".mail_protocol", function() {
        var type = $(this).val();
        if(type == 'smtp'){
          $('.smtp_area').slideDown();
        }else{
          $('.smtp_area').slideUp();
        }
    });


    $(document).on('keyup', ".slug_input", function() {

        $("#slug_add").val(base_url+$(this).val());
        $('.loader').html('<span class="spinner-border spinner-border-sm mb-2"></span>');

        var valName = $(this).val();
        if(/^[a-zA-Z0-9- ]*$/.test(valName) == false) {
            $("#name_illegal").slideDown();
            $('.loader').hide();
            $('.setup_bbtn').prop('disabled', true);
            $("#name_exist").slideUp();
            $("#name_available").slideUp();
            return false;
        }

        var url = base_url+'auth/check_username/'+valName;
        $.post(url, { data: 'value', 'csrf_test_name': csrf_token }, function(json) {
          if(json.st == 1){
            $('.setup_bbtn').prop('disabled', false);
            $('.loader').hide();
            $("#name_exist").slideUp();
            $("#name_illegal").slideUp();
            $("#name_available").slideDown();
          }else{
            $('.setup_bbtn').prop('disabled', true);
            $("#name_available").slideUp();
            $("#name_exist").slideDown();
          }
        }, 'json' );
        return false;
    });


    // pos system

    $(document).on('change', ".service_input", function() {

      $('.pos_date').html('');
      $('.pos_time').html('');
      $('.pos_step1_continue').prop('disabled', true);
      $('.pos_payment_method').val('');

      $("#load_staff_data").html('<span class="spinner-border spinner-border-sm ml-3 mt-4 mb-4"></span>');
      $(".pos_service_extra_area").html('');
      $(".pos_time_area").show();
      var service_id = $(this).val();
       $(".pos_service_info").show();
       $(".pos_service_empty").hide();

      if (service_id) {
          $(".service_extra").hide().html('');
          $(".pos_staff").html('');
          $(".service_extra_area_"+service_id).show();
      }

      window['serId'] = $(this).val();

      var url = base_url+'company/load_staff/'+window['serId'];
      $.post(url, { data: 'value', 'csrf_test_name': csrf_token }, (json)=>{
        $('input.serviceId').each(function() {
          $(this).val(window['serId']);
        })
        if (json.is_extra == 0) {
          $("html, body").animate({ scrollTop: $(document).height() }, 1000);
        }
        
        if(json.st == 1){
          $("#load_staff_data").show().html(json.loaded);
          $(".load_input_data").show().html(json.loaded_input);
          $(".service_extra_area_"+service_id).show().html(json.loaded_service_extra);
        }else{
          $("#load_staff_data").show().html(json.loaded);
          $(".load_input_data").show().html(json.loaded_input);
        }
      }, 'json' );

      
      var url = base_url+'admin/pos/get_service/'+service_id;
      $.post(url, { data: 'value', 'csrf_test_name': csrf_token }, function(json) {
        if(json.st == 1){

          $('.service_row_area').html(json.loaded);

          $(".appointment_datepicker").show();

          $('.sub_total').html(json.price);
          $('.total').html(json.price);

        }
      },'json');


      var url2 = base_url+'admin/pos/get_coupon/'+service_id;
      //alert(service_id); return false;
      $.post(url2, { data: 'value', 'csrf_test_name': csrf_token }, function(json) {
        if(json.st == 1){
          $(".pos_coupon_area").html(json.loaded);
          
        }else{
          $(".pos_coupon_area").html('');
        }
      }, 'json' );
    });


    
    $(document).on('click', ".staff_input", function() {

      $(".pos_calendar_area").show();
      var staffId = $(this).val();
      if(staffId != ''){
        $(".appointment_datepicker").show();
        $(".time_wrap").hide();
        var url = base_url+'admin/appointment/sess_staff/'+staffId;
        $.post(url, { data: 'value', 'csrf_test_name': csrf_token }, function(json) {
          if(json.st == 1){
            $("#load_work_cal").html('<div id="datepickers"></div>');
            $("#load_work").html(json.loaded);
          }else{
            $("#load_work").html(json.loaded);
          }
        }, 'json' );

        var url2 = base_url+'admin/pos/get_staff/'+staffId;
        $.post(url2, { data: 'value', 'csrf_test_name': csrf_token }, function(json) {
          if(json.st == 1){
            $(".pos_staff").html(json.loaded);
          }
        }, 'json' );
      }  
    });

    $(document).on('click', ".pos_service_extra", function() {
      var id = $(this).val();
      var check_extra = $('.check_extra_'+id).val();

      var service_price = $('.sub_total').text();
      var discount = $(".pos_coupon_discount").val();
      var discount_amount = (service_price * discount)/100;
      
      var url = base_url+'admin/pos/get_service_extra/'+id;
      $.post(url, { data: 'value', 'csrf_test_name': csrf_token }, function(json) {
        if(json.st == 1){
          if (check_extra == 1) {
            $('.single_service_extra_'+id).remove();
            $('.check_extra_'+id).val(0);

            var sub_total =  +service_price - +(json.se_price);
            var discount_amount = (sub_total * discount)/100;
            var total = +(sub_total) - (+discount_amount) ;
            $('.sub_total').html(sub_total);
            $('.total').html(total);
            $('.coupon_amount').html(discount_amount);
          }else{
            $(".pos_service_extra_title").html('Service extra');
            $(".pos_service_extra_area").append(json.loaded);
            $('.check_extra_'+id).val(1);

            var sub_total = +(json.se_price) + (+service_price) ;
            var discount_amount = (sub_total * discount)/100;
            var total = +(sub_total) - (+discount_amount) ;

            $('.sub_total').html(sub_total);
            $('.total').html(total);
            $('.coupon_amount').html(discount_amount);
          }
          
        }
      }, 'json' );
          
    });

    $(document).on('click', ".select_customer", function() {
      var customer_id = $(this).attr("data-id");

      var url = base_url+'admin/pos/get_customer/'+customer_id;
      $.post(url, { data: 'value', 'csrf_test_name': csrf_token }, function(json) {
        if(json.st == 1){
          $(".pos_customer").html(json.loaded);
          $(".control-sidebar").hide();
          $(".pos_customer_id").val(customer_id);
          
        }
      }, 'json' );
    });

    $(document).on('change', ".pos_coupon_code", function() {
      var coupon_id = $(this).val();

      //alert(coupon_id); return false;
      
      var customer_id = $('.pos_customer_id').val();
      var sub_total = $('.sub_total').text();
      if(coupon_id == 0){

        var url = base_url+'admin/pos/check_coupon/'+coupon_id;
        $.post(url,{ data: 'value', 'csrf_test_name': csrf_token, 'sub_total': sub_total, 'customer_id': customer_id },function(json){
            if(json.st == 1){
              $(".total").html(json.total_price);
              $(".coupon_amount").html(0);
            }
        },'json');
        
      }else{
        var url = base_url+'admin/pos/check_coupon/'+coupon_id;
        $.post(url,{ data: 'value', 'csrf_test_name': csrf_token, 'sub_total': sub_total, 'customer_id': customer_id },function(json){
            if(json.st == 1){
              $(".total").html(json.total_price);
              $(".coupon_amount").html(json.discount_amount);
              $(".pos_coupon_discount").val(json.discount);
            }
        },'json');
      }  
    });

    $(document).on('keyup', ".pos_service_search", function() {
      var value = $(this).val();
      
      if(value != ''){
        var url = base_url+'admin/pos/service_search/'+value;
        $.post(url,{ data: 'value', 'csrf_test_name': csrf_token }, function(json){
            if(json.st == 1){
              $(".service_search_area").html(json.loaded);
            }else{
              $(".service_search_area").html(json.loaded);
            }
        }, 'json');
      }else{
        location.reload();
      }  
    });

    $(document).on('keyup', ".pos_customer_search", function() {
      var value = $(this).val();
      
      if(value != ''){
        var url = base_url+'admin/pos/customer_search/'+value;
        $.post(url,{ data: 'value', 'csrf_test_name': csrf_token }, function(json){
            if(json.st == 1){
              $(".customer_search_area").html(json.loaded);
            }else{
              $(".customer_search_area").html(json.loaded);
            }
        }, 'json');
      }else{
      }  
    });

    $(document).on('click', ".add_new_customer", function() {
      $(".add_new_customer_area").show();
      $(".add_new_customer").addClass('active');
      $(".existing_customer").removeClass('active');
      $(".customer_search_area").hide();

    });

    $(document).on('click', ".existing_customer", function() {
      $(".add_new_customer_area").hide();
      $(".add_new_customer").removeClass('active');
      $(".existing_customer").addClass('active');
      $(".customer_search_area").show();

    });

    $(document).on('click', ".modify_pos_date", function() {
      $(".pos_calendar_area").show();
      $(".modify_pos_date").hide();

    });

    $(document).on('click', ".modify_pos_time", function() {
      $(".pos_time_area").show();
      $(".modify_pos_time").hide();

    });


    $(document).on('submit', ".pos_cadd_form", function() {
      $.post($('.pos_cadd_form').attr('action'), $('.pos_cadd_form').serialize(), function(json){
          if (json.st == 1) {
            $('.pos_cadd_form')[0].reset();
            $(".control-sidebar").hide();
            $(".pos_customer").html(json.loaded);
            $(".pos_customer_id").val(json.customer_id);
          }
      },'json');
      return false;
    });

    $(document).on('submit', ".pos_booking_form", function() {
      var sub_total = $('.sub_total').text();
      var discount = $('.coupon_amount').text();
      var total = $('.total').text();

      //alert(discount); return false;

      

      $.post($('.pos_booking_form').attr('action'), $('.pos_booking_form').serialize(), function(json){
          if (json.st == 1) {
            $('.pos_area').hide();
            $('.pos_payment_area').html(json.loaded);
            $('.pos_paying_amount').val(total);
            $('.step2_sub_total').html(sub_total);
            $('.step2_coupon_amount').html(discount);
            $('.step2_total').html(total);
          }
      },'json');
      return false;
    });

    $(document).on('change', ".pos_payment_method", function() {
      var payemt_method = $(this).val();
      if(payemt_method != ''){
        $('.pos_step1_continue').prop('disabled', false);
      }else{
        $('.pos_step1_continue').prop('disabled', true);
      }  
    });

    $(document).on('keyup', ".pos_received_amount", function() {
      var value = $(this).val();
      var total = $('.total').text();
      var change = value - total ;
      
      if(value != ''){
        $('.pos_change_return').html(change);
      }else{
        $('.pos_change_return').html('0');
      }
    });

    $(document).on('click', ".pos_step2_back", function() {
        $('.pos_area').show();
        $('.pos_payment_area').hide();
      
    });

    $(document).on('submit', ".confirm_pos_booking", function() {

      var sub_total = $('.sub_total').text();
      var discount = $('.coupon_amount').text();
      var total = $('.total').text();

       $('.invoice_sub_total').val(sub_total);
       $('.invoice_total').val(total);
       $('.invoice_coupon_amount').val(discount);
      //alert(sub_total); return false;
      $('.confirm_pos_booking_btn').html('<span class="spinner-border spinner-border-sm mb-2"></span>');

      $('.pos_paying_amount').prop('disabled', false);

      $.post($('.confirm_pos_booking').attr('action'), $('.confirm_pos_booking').serialize(), function(json){
          if (json.st == 1) {
            $('.pos_paying_amount').prop('disabled', true);

            $('.invoice_sub_total').html(sub_total);
            window.location.href=(json.url);

          }
      },'json');
      return false;
    });

     

    $('.print_invoice').on("click", function () {
      $('.print_area').printThis({
        base: "https://jasonday.github.io/printThis/"
      });
    });

    

    $(document).on('click', ".pos_print", function() {
      window.print();
    });




    // pos system end

    $(document).on('change', ".location", function() {
      var Id = $(this).val();
      if(Id != ''){
        var url = base_url+'company/load_sub_location/'+Id;
        $.post(url,{ data: 'value', 'csrf_test_name': csrf_token },function(data){
          $('.sub_area').slideDown();
          $('.sub_location').html(data);
          $('.sub_location').prop('disabled', false);
        }
        );
      }  
    });


    $(document).on('change', ".duration_type", function() {
      var type = $(this).val();
      if(type == 'day'){
        $('.duration_input').prop('disabled', true);
        $('.duration_input').val('1');
      }else{
        $('.duration_input').prop('disabled', false);
        $('.duration_input').val('');
      }
    });


    $(document).on('click', ".icon_image", function() {
      var value = $(this).val();
      //alert(value); return false;
      if(value == 1){
        $('.category_icon').show();
        $('.category_image').hide();
      }else{
        $('.category_icon').hide();
        $('.category_image').show();
      }
    });



    $("body").on('click','.time_btn',function(){
        $('.time_btn').removeClass('active');
        $(this).addClass('active');

        var time = $('.time_inp').val();
        $(".pos_time").html('<i class="fa fa-clock"></i> '+time);
        $('.pos_time_area').hide();
        $('.modify_pos_time').show();
    });


    $(document).on('change', ".service_staffs", function() {
      var Id = $(this).val();
      if(Id != ''){
        $(".appointment_datepicker").show();
        $(".time_wrap").hide();

        var url = base_url+'admin/appointment/load_staff/'+Id;
        $.post(url,{ data: 'value', 'csrf_test_name': csrf_token },function(data){
          $('.staff_area').slideDown();
          $('.staffs').html(data);
          $("#load_work").html(json.loaded);
        });
      }  
    });

    $(document).on('change', "#service_staffs", function() {
      var Id = $(this).val();
      var appointment_id =  $('.appointment_id').val();
      $('.edit_area').hide();

      if(Id != ''){

        var url = base_url+'admin/appointment/load_service_extra/'+Id + '/' + appointment_id;
        $.post(url, { data: 'value', 'csrf_test_name': csrf_token }, function(json) {
          if(json.st == 1){
            $('.load_service_extra').html(json.loaded_service_extra);
          }
        }, 'json' );
        return false;
      }  
    });


    $(document).on('change', ".staffs", function() {
        var staffId = $(this).val();
        if(staffId != ''){
            $(".appointment_datepicker").show();
            $(".time_wrap").hide();
            var url = base_url+'admin/appointment/sess_staff/'+staffId;
            $.post(url, { data: 'value', 'csrf_test_name': csrf_token }, function(json) {
              if(json.st == 1){
                $("#load_work_cal").html('<div id="datepickers"></div>');
                $("#load_work").html(json.loaded);
              }else{
                $("#load_work").html(json.loaded);
              }
            }, 'json' );

        }  
    });



    $(document).on('click', ".apply_coupon", function() {


        var code = $('.coupon_code').val();
        if (code == '') {
            $(".apply_msg_error").show().html('Invalid Code');
            return false;
        }

        var plan_id = $('.plan_id').val();
        var billing_type = $('.billing_type').val();
        var url = base_url+'admin/coupons/apply_coupon/'+code+'/'+plan_id+'/'+billing_type;
        var cur_path = window.location;

        $.post(url, { data: 'value', 'csrf_test_name': csrf_token }, function(json) {
          if(json.st == 1){
            $('.apply_coupon').prop('disabled', true);
            window.location.href = cur_path+'?coupon='+code;
          }else{
            $(".apply_msg_success").hide();
            $(".apply_msg_error").show().html(json.msg);
          }
        }, 'json' );
        return false;
    });


    $(document).on('click', ".apply_coupon_old", function() {
        var code = $('.coupon_code').val();
        var url = base_url+'admin/coupons/apply_coupon/'+code;
        $.post(url, { data: 'value', 'csrf_test_name': csrf_token }, function(json) {
          if(json.st == 1){
            $('.apply_coupon').prop('disabled', true);
            var total_price = json.total_price;
            var tatalCost = Number(total_price) - (total_price * (json.discount/100));
            var coupon_amount = total_price - tatalCost;

            $(".percent").html(' - '+json.discount+'%');
            $('.paypal_price').prop("value", tatalCost.toFixed(2)); 
            $(".coupon_amount").html(coupon_amount.toFixed(2));
            $(".final_amount").html(tatalCost.toFixed(2));

            $(".upgrade_area").show();
            $(".apply_msg_error").hide();
            $(".apply_msg_success").show().html(json.msg);
          }else{
            $(".apply_msg_success").hide();
            $(".apply_msg_error").show().html(json.msg);
          }
        }, 'json' );
        return false;
    });



    $(document).ready(function(){
        $(".filter-action").click(function(){
          $(".filter_popup").toggleClass("showFilter");
        });

        $(".linkd").click(function(){
          $(".coupon_area").show();
          $(".linkd_hide").hide();
        });

        $(".fs-close").click(function(){
          $(".feature-steps").hide();
          return false;
        });


        $(".apply-button").click(function(){
            $(".filter_popup").toggleClass("showFilter");
            $(".filter, .filter-remove, .fa-plus, .fa-filter").toggleClass("filter-hidden");
            $(".filter-dropdown-text").text("Add filter");
        });
      
        $(".filter-remove").click(function(){
          $(".filter, .filter-remove, .fa-plus, .fa-filter").toggleClass("filter-hidden");
          $(".filter-dropdown-text").text("Filter dataset");
        });

    });


    $(document).ready(function(){
        $(".add_time_row").on('click', function() {
            var val = $(this).attr("data-id");
            $('.houritem_'+val).append(`
                <div class="mb-2 row new_item_row_`+val+`">
                    <div class="col-sm-5 pr-3 mb-2 ">
                        <div class="input-group">
                            <div class="input-group-prepend">
                              <span class="input-group-text"><i class="far fa-clock"></i></span>
                            </div>
                            <input type="text" placeholder="`+msg_start_time+`" class="form-control form-control-sm timepicker" name="start_time_`+val+`[]" value="" autocomplete="off">
                        </div>
                    </div>

                    <div class="col-sm-5 mb-2">
                        <div class="input-group">
                            <div class="input-group-prepend">
                              <span class="input-group-text"><i class="far fa-clock"></i></span>
                            </div>
                            <input type="text" placeholder="`+msg_end_time+`" class="form-control form-control-sm timepicker" name="end_time_`+val+`[]" value="" autocomplete="off">
                        </div>
                    </div>

                    <div class="col-sm-2 mb-2">
                        <a href="javascript:void(0);" class="remove_time_row text-danger"><i class="lnib lni-close"></i></a>
                    </div>
                </div>
            `);
            return false;
        });

        $(".main_item").on('click','.remove_time_row',function(){
            $(this).parent().parent().remove();
            return false;
        });


        $(document).on('click', ".enable_service_extra", function() {
        
          if ($(this).prop('checked')) {
            $('.service_extra_area').show();
          }else{
            $('.service_extra_area').hide();
          }
        
          
        });

        $(document).on('click', ".enable_buffer_time", function() {
        
          if ($(this).prop('checked')) {
            $('.buffer_time_are').show();
          }else{
            $('.buffer_time_are').hide();
          }
        
          
        });


        $('.is_reccuring').on('change', function () {

          var value = $('.is_reccuring').val();
          if (value == 2) {
            $('.recurring_service').show();
          }else{
            $('.recurring_service').hide();
          }
          return false;
        });
    });



    $(document).ready(function(){
        $(".add_service_row").on('click', function() {
            var val = 0;
            $('.load_new_service_group').append(`
                <div class="row service_extra_row mt-4 p-3 new_item_row_`+val+`">
                    <div class="col-md-12 pr-0 mt-2">
                        <div class="form-group">
                            <label>Name <span class="text-danger">*</span></label>
                            <input type="text" placeholder="" class="form-control form-control" name="service_extra_name[]" value="" autocomplete="off" required="required">
                        </div>
                    </div>

                    <div class="col-md-12 pr-0">
                        <div class="form-group">
                            <label>Price <span class="text-danger">*</span></label>
                            <input type="text" placeholder="" class="form-control form-control" name="service_extra_price[]  " value=""  autocomplete="off" required="required">
                        </div>
                    </div>


                    <div class="col-md-12">
                      <div class="form-group">
                        <label>Duration <span class="text-danger">*</span></label>
                        <div class="input-group">
                          
                            <div>
                              <select class="form-control cus-ra-left duration_type" name="duration_type">
                                  <option value="minute" >Minute</option>
                                  <option value="hour" >Hour</option>
                              </select>
                            </div>
                            

                            <input type="number" class="form-control cus-ra-right duration_input" name="duration[]" value=""  >
                            
                        </div>
                      </div>
                    </div>



                    <div class="col-md-8 pr-0">
                        <div class="mb-2">
                          <select class="form-control" name="extra_status[]">
                              <option value="1">Show</option>
                              <option value="0" >Hide</option>
                          </select>
                        </div>
                    </div>

                    <div class="col-md-4 text-right mb-2 mt-2">
                        <a href="javascript:void(0);" class="remove_time_row text-danger"><i class="bi bi-x"></i></a>
                    </div>
                </div>
            `);
            return false;
        });

        $(".main_item").on('click','.remove_time_row',function(){
            $(this).parent().parent().remove();
        });

        return false;
    });







    $('.day_option').on('change', function () {
        var val = $(this).val();

        if ($(this).prop('checked')) {
          $('.hideable_'+val).slideDown();
          console.log(val);
        }else{
          $('.hideable_'+val).slideUp();
          console.log(val);
        }
        return false;
    });

    $(document).on('click', ".package_btn", function() {
      var billType = $('.billing_type').val();
      var url = $(this).attr('href')+'/'+billType;
      window.location.href=url;
      return false;
    });



    $(".allow_zoom").on('click', function() {
      var $box = $(this);
      if ($box.is(":checked")) {
        $box.prop("checked", true);
        $('.link_area').slideDown();
      } else {
        $box.prop("checked", false);
           $('.link_area').slideUp();
      }
    });

    $(".allow_gmeet").on('click', function() {
      var $box = $(this);
      if ($box.is(":checked")) {
        $box.prop("checked", true);
        $('.toggle_area').slideDown();
      } else {
        $box.prop("checked", false);
           $('.toggle_area').slideUp();
      }
    });


    $(".interval_settings").on('change', function() {
      var val = $(this).val();
      if (val == 1) {
          $('.interval_area').slideUp();
      } else {
         $('.interval_area').slideDown();
      }
    });

    $(".tax_settings").on('change', function() {
      var val = $(this).val();
      if (val == 2) {
          $('.tax_set_area').slideUp();
      } else {
         $('.tax_set_area').slideDown();
      }
    });

    $(document).on('click', ".toggle_btn", function() {
        $('.toggle_area').toggle();
        return false;
    });

  
    $(document).on('click', ".add_btn", function() {
        $('.add_area').attr( "style", "display: block !important;");
        $('.list_area').attr( "style", "display: none !important;");
        return false;
    });

    $(document).on('click', ".cancel_btn", function() {
        $('.add_area').attr( "style", "display: none !important;");
        $('.list_area').attr( "style", "display: block !important;");
        return false;
    });


    $(document).on('click', ".add_btn2", function() {
        $('.add_area2').attr( "style", "display: block !important;");
        $('.list_area2').attr( "style", "display: none !important;");
        return false;
    });

    $(document).on('click', ".cancel_btn2", function() {
        $('.add_area2').attr( "style", "display: none !important;");
        $('.list_area2').attr( "style", "display: block !important;");
        return false;
    });



    $(document).on('change', ".sort", function() {
        $('.sort_form').submit();
    });


    $(document).on('change', ".sort_appoint", function() {
        $('.sort_form').submit();
    });

    $('.active_status').on('change', function() {
      var id = $(this).attr('data-id');
      var value = $(this).val();
      var url = base_url+'admin/appointment/status_update/'+value+'/'+id;

      $.post(url, { data: 'value', 'csrf_test_name': csrf_token }, function(json) {
          if(json.st == 1){     
              location.reload();
          }
      },'json');
      return false;
    });


  $(".custom-btngp").on('click', function() {
      var priceVal = $(this).find('.switch_price').val();
      $(".custom-btngp").removeClass('actives');
      if (priceVal == 'monthly') {
            $('.monthly_price').show();
            $('.yearly_price').hide();
            $('.lifetime_price').hide();
            $('.billing_type').val('monthly');
        }else if (priceVal == 'lifetime') {
            $('.monthly_price').hide();
            $('.yearly_price').hide();
            $('.lifetime_price').show();
            $('.billing_type').val('lifetime');
        } else {
            $('.yearly_price').show();
            $('.monthly_price').hide();     
            $('.lifetime_price').hide();       
            $('.billing_type').val('yearly');
        }
  });


  $(document).on('click', ".notify_customer", function() {

      var del_url = $(this).attr('href');
      var Id = $(this).attr('data-id');

          swal({
            title: msg_are_you_sure,
            text: msg_sms_notify,
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: msg_yes,
            closeOnConfirm: false
          },
          function(){ 

              $.post(del_url, { data: 'value', 'csrf_test_name': csrf_token }, function(json) {
                  if(json.st == 1){     
                      swal({
                        title: msg_success,
                        text: msg_send_success,
                        type: "success",
                        showCancelButton: false
                      }),                
                      $("#row_"+Id).slideUp();
                  }else{
                    swal({
                      title: msg_error,
                      text: json.msg,
                      type: "error",
                      showConfirmButton: true
                    });
                  }
              },'json');

          });

      return false;

  });


  // Event js code start

    $(".is_seatable").on('click', function() {
        var $box = $(this);
        if ($box.is(":checked")) {
          $box.prop("checked", true);
          $('.seat_area').slideDown();
        } else {
          $box.prop("checked", false);
             $('.seat_area').slideUp();
        }
    });

    $(".is_organizer").on('click', function() {
        var $box = $(this);
        if ($box.is(":checked")) {
          $box.prop("checked", true);
          $('.organizer_area').slideDown();
        } else {
          $box.prop("checked", false);
             $('.organizer_area').slideUp();
        }
    });

    $(".enable_sales").on('click', function() {
        var $box = $(this);
        if ($box.is(":checked")) {
          $box.prop("checked", true);
          $('.sales_area').slideDown();
        } else {
          $box.prop("checked", false);
             $('.sales_area').slideUp();
        }
    });

    

    $(".add_ticket").on('click', function() {
      var url = base_url+'admin/events/add_more_ticket';
      $.post(url, { data: 'value', 'csrf_test_name': csrf_token }, function(json) {
        $('.ticket_section').append(json.loaded);
      },'json');
      return false;
    });


    $(document).on('click','.cancel_ticket',function(){
      $(this).parent().parent().remove();
      return false;
    });

    $('.active_event_status').on('change', function() {
      var id = $(this).attr('data-id');
      var value = $(this).val();
      var url = base_url+'admin/events/status_update/'+value+'/'+id;

      $.post(url, { data: 'value', 'csrf_test_name': csrf_token }, function(json) {
          if(json.st == 1){     
              location.reload();
          }
      },'json');
      return false;
    });


    $(document).on('change', ".booking_sort", function() {
        $('.event_sort_form').submit();
    });


    $(document).on('change', ".event_tickets", function() {
      var Id = $(this).val();
      if(Id != ''){

        var url = base_url+'admin/events/load_ticket/'+Id;
        $.post(url,{ data: 'value', 'csrf_test_name': csrf_token },function(data){
          $('.ticket_area').slideDown();
          $('.quantity_area').slideDown();
          $('.events').html(data);
        });
      }  
    });


  // Event js code end


  // Deposite js start
    
    $(document).on('keyup', ".service_price", function() {

      var service_price = $(this).val();
        //alert(service_price); 
      $(this).val(service_price);
      
      if (service_price > 0) {
        $('.deposite_payment').show();
      }else{
        $('.deposite_payment').hide();
      }

    });


    $(document).on('click', ".enable_deposite_payment", function() {
        
      if ($(this).prop('checked')) {
        $('.deposite_area').show();
      }else{
        $('.deposite_area').hide();
      }
    
      
    });


    $(document).on('change', ".deposite_type", function() {
      var deposite_type = $(this).val();

      if(deposite_type == 'fixed'){
        $('.deposite_amount').show();
        $('.deposite_percentage').hide();
      }else{
        $('.deposite_percentage').show();
        $('.deposite_amount').hide();
      }

    });


    $(document).ready(function(){
      $(document).on('keyup', ".fixed_amount", function() {

        var service_price = $('.service_price').val();
        var fixed_amount = $(this).val();


        //alert(service_price);
        if (fixed_amount !== "" && !isNaN(fixed_amount) && Number(fixed_amount) >= service_price) {
          $(this).val('');
        }

        return false;

      });
    });

  // Deposite js end  


  
  

  $(document).on('click', ".delete_item", function() {

      var del_url = $(this).attr('href');
      var Id = $(this).attr('data-id');

          swal({
            title: msg_are_you_sure,
            text: msg_not_recover_file,
            type: "warning",
            showCancelButton: true,
            cancelButtonText: msg_cancel,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: msg_yes,
            closeOnConfirm: false
          },
          function(){ 

              $.post(del_url, { data: 'value', 'csrf_test_name': csrf_token }, function(json) {
                  if(json.st == 1){     
                      swal({
                        title: msg_success,
                        text: msg_del_success,
                        type: "success",
                        showCancelButton: false
                      }),                
                      $("#row_"+Id).slideUp();
                  }
              },'json');

          });

      return false;

  });

  $(document).on('click', ".delete_item_load", function() {

      var del_url = $(this).attr('href');
      var Id = $(this).attr('data-id');

          swal({
            title: msg_are_you_sure,
            text: msg_not_recover_file,
            type: "warning",
            showCancelButton: true,
            cancelButtonText: msg_cancel,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: msg_yes,
            closeOnConfirm: false
          },
          function(){ 

              $.post(del_url, { data: 'value', 'csrf_test_name': csrf_token }, function(json) {
                  if(json.st == 1){     
                     window.location.reload();
                  }
              },'json');

          });

      return false;

  });


  $(document).on('click', ".delete_time_item", function() {

      var del_url = $(this).attr('href');
      var Id = $(this).attr('data-id');

          swal({
            title: msg_are_you_sure,
            text: msg_not_recover_file,
            type: "warning",
            showCancelButton: true,
            cancelButtonText: msg_cancel,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: msg_yes,
            closeOnConfirm: false
          },
          function(){ 

              $.post(del_url, { data: 'value', 'csrf_test_name': csrf_token }, function(json) {
                  if(json.st == 1){     
                      window.location.reload();
                  }
              },'json');

          });

      return false;

  });


    $(document).on('submit', "#cahage_pass_form", function() {
        $.post($('#cahage_pass_form').attr('action'), $('#cahage_pass_form').serialize(), function(json){
            if (json.st == 1) {
                $('#cahage_pass_form')[0].reset();
                swal({
                      title: msg_congratulations,
                      text: msg_password_reset_success_msg,
                      type: "success",
                      showConfirmButton: true
                });
            }else if (json.st == 2) {
                $('#cahage_pass_form')[0].reset();
                swal({
                  title: msg_opps,
                  text: msg_confirm_pass_not_match_msg,
                  type: "error",
                  showConfirmButton: true
                });
            }else {
                $('#cahage_pass_form')[0].reset();
                swal({
                  title: msg_error,
                  text: msg_old_password_doesnt_match,
                  type: "error",
                  showConfirmButton: true
                });
            }
        },'json');
        return false;
    });


    
    $(document).on('submit', "#document_generate", function() {
        
        if( !$('.prompt').val() ) {
          $('.prompt').addClass('red-line');
          return false;
        }

        $(".generate_btn").html('<span class="spinner-border spinner-border-sm"></span> &nbsp; Generating');
        $(".generate_btn").prop('disabled', true);
        $(".empty_result_area").hide();
        $(".result_loading").show();

        $.post($('#document_generate').attr('action'), $('#document_generate').serialize(), function(json){
            if (json.st == 1) {
                $('#document_generate')[0].reset();
                $(".result_head").show();
                $(".generate_btn").prop('disabled', false);
                $(".generate_btn").html('Generate');
                $(".result_loading").hide();
                $("#load_result").html(json.loaded);

                if ($(".result-body").height() > 650) {
                  $(".result-body").addClass('cus_scroll');
                }
            }else {
                $(".result_loading").hide();
                $(".generate_btn").prop('disabled', false);
                $(".generate_btn").html('Generate');
                $("#load_result").html(json.loaded);
            }
        },'json');
        return false;
    });


     $(document).on('click', ".plan_status", function() {
        var pkgId = $(this).attr('data-id');
        var status = $(this).val();

        var url = base_url+'admin/package/status_update/'+status+'/'+pkgId;
        $.post(url, { data: 'value', 'csrf_test_name': csrf_token }, function(json) {
           if(json.st == 1){
                window.location.reload();
            }
        }, 'json' );
        return false;
    });


    $(document).on('click', ".enable_category", function() {
        if ($(this).prop('checked')) {
          var status = 1;
        }else{
          var status = 0;
        }
      
        var url = base_url+'admin/services/category_update/'+status;
        $.post(url, { data: 'value', 'csrf_test_name': csrf_token }, function(json) {
           if(json.st == 1){
                window.location.reload();
            }
        }, 'json' );
        return false;
    });




    $(document).on('click', ".enable_location", function() {
        
        if ($(this).prop('checked')) {
          var status = 1;
        }else{
          var status = 0;
        }
      
        var url = base_url+'admin/location/status_update/'+status;
        $.post(url, { data: 'value', 'csrf_test_name': csrf_token }, function(json) {
           if(json.st == 1){
                window.location.reload();
            }
        }, 'json' );
        return false;
    });

    
    $(".group_booking").on('change', function() {
        if ($(this).is(":checked")) {
            $('.person_area').slideDown();
        } else {
            $('.person_area').slideUp();
        }
        return false;
    });


    $(".appoint_reminder").on('change', function() {
        if ($(this).is(":checked")) {
            $('.reminderd_area').slideDown();
        } else {
            $('.reminderd_area').slideUp();
        }
        return false;
    });


    // Notifications

     $(document).on('click', function(){
        if( this.class != 'show_noti') {
          $(".show_noti").fadeOut();
        }
      });

      $(document).on('click', '.header_notifications', function(){
        var url = base_url+'admin/notifications/my';
        $.post(url, { data: 'value', 'csrf_test_name': csrf_token }, function(json) {
          if(json.st == 1){
            $(".header_notifications_area").html(json.noti);
            $(".show_noti").show();
            $('.unseen-count').text('0');
          }
        }, 'json' );
          return false;
      });






  /**
   * --------------------------------------------
   * AdminLTE ControlSidebar.js
   * License MIT
   * --------------------------------------------
   */
  var ControlSidebar = function ($) {
    /**
     * Constants
     * ====================================================
     */
    var NAME = 'ControlSidebar';
    var DATA_KEY = 'lte.controlsidebar';
    var EVENT_KEY = "." + DATA_KEY;
    var JQUERY_NO_CONFLICT = $.fn[NAME];
    var Event = {
      COLLAPSED: "collapsed" + EVENT_KEY,
      EXPANDED: "expanded" + EVENT_KEY
    };
    var Selector = {
      CONTROL_SIDEBAR: '.control-sidebar',
      CONTROL_SIDEBAR_CONTENT: '.control-sidebar-content',
      DATA_TOGGLE: '[data-widget="control-sidebar"]',
      CONTENT: '.content-wrapper',
      HEADER: '.main-header',
      FOOTER: '.main-footer'
    };
    var ClassName = {
      CONTROL_SIDEBAR_ANIMATE: 'control-sidebar-animate',
      CONTROL_SIDEBAR_OPEN: 'control-sidebar-open',
      CONTROL_SIDEBAR_SLIDE: 'control-sidebar-slide-open',
      LAYOUT_FIXED: 'layout-fixed',
      NAVBAR_FIXED: 'layout-navbar-fixed',
      NAVBAR_SM_FIXED: 'layout-sm-navbar-fixed',
      NAVBAR_MD_FIXED: 'layout-md-navbar-fixed',
      NAVBAR_LG_FIXED: 'layout-lg-navbar-fixed',
      NAVBAR_XL_FIXED: 'layout-xl-navbar-fixed',
      FOOTER_FIXED: 'layout-footer-fixed',
      FOOTER_SM_FIXED: 'layout-sm-footer-fixed',
      FOOTER_MD_FIXED: 'layout-md-footer-fixed',
      FOOTER_LG_FIXED: 'layout-lg-footer-fixed',
      FOOTER_XL_FIXED: 'layout-xl-footer-fixed'
    };
    var Default = {
      controlsidebarSlide: true,
      scrollbarTheme: 'os-theme-light',
      scrollbarAutoHide: 'l'
    };
    /**
     * Class Definition
     * ====================================================
     */

    var ControlSidebar = /*#__PURE__*/function () {
      function ControlSidebar(element, config) {
        this._element = element;
        this._config = config;

        this._init();
      } // Public


      var _proto = ControlSidebar.prototype;

      _proto.collapse = function collapse() {
        // Show the control sidebar
        if (this._config.controlsidebarSlide) {
          $('html').addClass(ClassName.CONTROL_SIDEBAR_ANIMATE);
          $('body').removeClass(ClassName.CONTROL_SIDEBAR_SLIDE).delay(300).queue(function () {
            $(Selector.CONTROL_SIDEBAR).hide();
            $('html').removeClass(ClassName.CONTROL_SIDEBAR_ANIMATE);
            $(this).dequeue();
          });
        } else {
          $('body').removeClass(ClassName.CONTROL_SIDEBAR_OPEN);
        }

        var collapsedEvent = $.Event(Event.COLLAPSED);
        $(this._element).trigger(collapsedEvent);
      };

      _proto.show = function show() {
        // Collapse the control sidebar
        if (this._config.controlsidebarSlide) {
          $('html').addClass(ClassName.CONTROL_SIDEBAR_ANIMATE);
          $(Selector.CONTROL_SIDEBAR).show().delay(10).queue(function () {
            $('body').addClass(ClassName.CONTROL_SIDEBAR_SLIDE).delay(300).queue(function () {
              $('html').removeClass(ClassName.CONTROL_SIDEBAR_ANIMATE);
              $(this).dequeue();
            });
            $(this).dequeue();
          });
        } else {
          $('body').addClass(ClassName.CONTROL_SIDEBAR_OPEN);
        }

        var expandedEvent = $.Event(Event.EXPANDED);
        $(this._element).trigger(expandedEvent);
      };

      _proto.toggle = function toggle() {
        var shouldClose = $('body').hasClass(ClassName.CONTROL_SIDEBAR_OPEN) || $('body').hasClass(ClassName.CONTROL_SIDEBAR_SLIDE);

        if (shouldClose) {
          // Close the control sidebar
          this.collapse();
        } else {
          // Open the control sidebar
          this.show();
        }
      } // Private
      ;

      _proto._init = function _init() {
        var _this = this;

        this._fixHeight();

        this._fixScrollHeight();

        $(window).resize(function () {
          _this._fixHeight();

          _this._fixScrollHeight();
        });
        $(window).scroll(function () {
          if ($('body').hasClass(ClassName.CONTROL_SIDEBAR_OPEN) || $('body').hasClass(ClassName.CONTROL_SIDEBAR_SLIDE)) {
            _this._fixScrollHeight();
          }
        });
      };

      _proto._fixScrollHeight = function _fixScrollHeight() {
        var heights = {
          scroll: $(document).height(),
          window: $(window).height(),
          header: $(Selector.HEADER).outerHeight(),
          footer: $(Selector.FOOTER).outerHeight()
        };
        var positions = {
          bottom: Math.abs(heights.window + $(window).scrollTop() - heights.scroll),
          top: $(window).scrollTop()
        };
        var navbarFixed = false;
        var footerFixed = false;

        if ($('body').hasClass(ClassName.LAYOUT_FIXED)) {
          if ($('body').hasClass(ClassName.NAVBAR_FIXED) || $('body').hasClass(ClassName.NAVBAR_SM_FIXED) || $('body').hasClass(ClassName.NAVBAR_MD_FIXED) || $('body').hasClass(ClassName.NAVBAR_LG_FIXED) || $('body').hasClass(ClassName.NAVBAR_XL_FIXED)) {
            if ($(Selector.HEADER).css("position") === "fixed") {
              navbarFixed = true;
            }
          }

          if ($('body').hasClass(ClassName.FOOTER_FIXED) || $('body').hasClass(ClassName.FOOTER_SM_FIXED) || $('body').hasClass(ClassName.FOOTER_MD_FIXED) || $('body').hasClass(ClassName.FOOTER_LG_FIXED) || $('body').hasClass(ClassName.FOOTER_XL_FIXED)) {
            if ($(Selector.FOOTER).css("position") === "fixed") {
              footerFixed = true;
            }
          }

          if (positions.top === 0 && positions.bottom === 0) {
            $(Selector.CONTROL_SIDEBAR).css('bottom', heights.footer);
            $(Selector.CONTROL_SIDEBAR).css('top', heights.header);
            $(Selector.CONTROL_SIDEBAR + ', ' + Selector.CONTROL_SIDEBAR + ' ' + Selector.CONTROL_SIDEBAR_CONTENT).css('height', heights.window - (heights.header + heights.footer));
          } else if (positions.bottom <= heights.footer) {
            if (footerFixed === false) {
              $(Selector.CONTROL_SIDEBAR).css('bottom', heights.footer - positions.bottom);
              $(Selector.CONTROL_SIDEBAR + ', ' + Selector.CONTROL_SIDEBAR + ' ' + Selector.CONTROL_SIDEBAR_CONTENT).css('height', heights.window - (heights.footer - positions.bottom));
            } else {
              $(Selector.CONTROL_SIDEBAR).css('bottom', heights.footer);
            }
          } else if (positions.top <= heights.header) {
            if (navbarFixed === false) {
              $(Selector.CONTROL_SIDEBAR).css('top', heights.header - positions.top);
              $(Selector.CONTROL_SIDEBAR + ', ' + Selector.CONTROL_SIDEBAR + ' ' + Selector.CONTROL_SIDEBAR_CONTENT).css('height', heights.window - (heights.header - positions.top));
            } else {
              $(Selector.CONTROL_SIDEBAR).css('top', heights.header);
            }
          } else {
            if (navbarFixed === false) {
              $(Selector.CONTROL_SIDEBAR).css('top', 0);
              $(Selector.CONTROL_SIDEBAR + ', ' + Selector.CONTROL_SIDEBAR + ' ' + Selector.CONTROL_SIDEBAR_CONTENT).css('height', heights.window);
            } else {
              $(Selector.CONTROL_SIDEBAR).css('top', heights.header);
            }
          }
        }
      };

      _proto._fixHeight = function _fixHeight() {
        var heights = {
          window: $(window).height(),
          header: $(Selector.HEADER).outerHeight(),
          footer: $(Selector.FOOTER).outerHeight()
        };

        if ($('body').hasClass(ClassName.LAYOUT_FIXED)) {
          var sidebarHeight = heights.window - heights.header;

          if ($('body').hasClass(ClassName.FOOTER_FIXED) || $('body').hasClass(ClassName.FOOTER_SM_FIXED) || $('body').hasClass(ClassName.FOOTER_MD_FIXED) || $('body').hasClass(ClassName.FOOTER_LG_FIXED) || $('body').hasClass(ClassName.FOOTER_XL_FIXED)) {
            if ($(Selector.FOOTER).css("position") === "fixed") {
              sidebarHeight = heights.window - heights.header - heights.footer;
            }
          }

          $(Selector.CONTROL_SIDEBAR + ' ' + Selector.CONTROL_SIDEBAR_CONTENT).css('height', sidebarHeight);

          if (typeof $.fn.overlayScrollbars !== 'undefined') {
            $(Selector.CONTROL_SIDEBAR + ' ' + Selector.CONTROL_SIDEBAR_CONTENT).overlayScrollbars({
              className: this._config.scrollbarTheme,
              sizeAutoCapable: true,
              scrollbars: {
                autoHide: this._config.scrollbarAutoHide,
                clickScrolling: true
              }
            });
          }
        }
      } // Static
      ;

      ControlSidebar._jQueryInterface = function _jQueryInterface(operation) {
        return this.each(function () {
          var data = $(this).data(DATA_KEY);

          var _options = $.extend({}, Default, $(this).data());

          if (!data) {
            data = new ControlSidebar(this, _options);
            $(this).data(DATA_KEY, data);
          }

          if (data[operation] === 'undefined') {
            throw new Error(operation + " is not a function");
          }

          data[operation]();
        });
      };

      return ControlSidebar;
    }();
    /**
     *
     * Data Api implementation
     * ====================================================
     */


    $(document).on('click', Selector.DATA_TOGGLE, function (event) {
      event.preventDefault();

      ControlSidebar._jQueryInterface.call($(this), 'toggle');
    });
    /**
     * jQuery API
     * ====================================================
     */

    $.fn[NAME] = ControlSidebar._jQueryInterface;
    $.fn[NAME].Constructor = ControlSidebar;

    $.fn[NAME].noConflict = function () {
      $.fn[NAME] = JQUERY_NO_CONFLICT;
      return ControlSidebar._jQueryInterface;
    };

    return ControlSidebar;
  }(jQuery);

  /**
   * --------------------------------------------
   * AdminLTE Layout.js
   * License MIT
   * --------------------------------------------
   */
  var Layout = function ($) {
    /**
     * Constants
     * ====================================================
     */
    var NAME = 'Layout';
    var DATA_KEY = 'lte.layout';
    var JQUERY_NO_CONFLICT = $.fn[NAME];
    var Selector = {
      HEADER: '.main-header',
      MAIN_SIDEBAR: '.main-sidebar',
      SIDEBAR: '.main-sidebar .sidebar',
      CONTENT: '.content-wrapper',
      BRAND: '.brand-link',
      CONTENT_HEADER: '.content-header',
      WRAPPER: '.wrapper',
      CONTROL_SIDEBAR: '.control-sidebar',
      CONTROL_SIDEBAR_CONTENT: '.control-sidebar-content',
      CONTROL_SIDEBAR_BTN: '[data-widget="control-sidebar"]',
      LAYOUT_FIXED: '.layout-fixed',
      FOOTER: '.main-footer',
      PUSHMENU_BTN: '[data-widget="pushmenu"]',
      LOGIN_BOX: '.login-box',
      REGISTER_BOX: '.register-box'
    };
    var ClassName = {
      HOLD: 'hold-transition',
      SIDEBAR: 'main-sidebar',
      CONTENT_FIXED: 'content-fixed',
      SIDEBAR_FOCUSED: 'sidebar-focused',
      LAYOUT_FIXED: 'layout-fixed',
      NAVBAR_FIXED: 'layout-navbar-fixed',
      FOOTER_FIXED: 'layout-footer-fixed',
      LOGIN_PAGE: 'login-page',
      REGISTER_PAGE: 'register-page',
      CONTROL_SIDEBAR_SLIDE_OPEN: 'control-sidebar-slide-open',
      CONTROL_SIDEBAR_OPEN: 'control-sidebar-open'
    };
    var Default = {
      scrollbarTheme: 'os-theme-light',
      scrollbarAutoHide: 'l',
      panelAutoHeight: true,
      loginRegisterAutoHeight: true
    };
    /**
     * Class Definition
     * ====================================================
     */

    var Layout = /*#__PURE__*/function () {
      function Layout(element, config) {
        this._config = config;
        this._element = element;

        this._init();
      } // Public


      var _proto = Layout.prototype;

      _proto.fixLayoutHeight = function fixLayoutHeight(extra) {
        if (extra === void 0) {
          extra = null;
        }

        var control_sidebar = 0;

        if ($('body').hasClass(ClassName.CONTROL_SIDEBAR_SLIDE_OPEN) || $('body').hasClass(ClassName.CONTROL_SIDEBAR_OPEN) || extra == 'control_sidebar') {
          control_sidebar = $(Selector.CONTROL_SIDEBAR_CONTENT).height();
        }

        var heights = {
          window: $(window).height(),
          header: $(Selector.HEADER).length !== 0 ? $(Selector.HEADER).outerHeight() : 0,
          footer: $(Selector.FOOTER).length !== 0 ? $(Selector.FOOTER).outerHeight() : 0,
          sidebar: $(Selector.SIDEBAR).length !== 0 ? $(Selector.SIDEBAR).height() : 0,
          control_sidebar: control_sidebar
        };

        var max = this._max(heights);

        var offset = this._config.panelAutoHeight;

        if (offset === true) {
          offset = 0;
        }

        if (offset !== false) {
          if (max == heights.control_sidebar) {
            $(Selector.CONTENT).css('min-height', max + offset);
          } else if (max == heights.window) {
            $(Selector.CONTENT).css('min-height', max + offset - heights.header - heights.footer);
          } else {
            $(Selector.CONTENT).css('min-height', max + offset - heights.header);
          }

          if (this._isFooterFixed()) {
            $(Selector.CONTENT).css('min-height', parseFloat($(Selector.CONTENT).css('min-height')) + heights.footer);
          }
        }

        if ($('body').hasClass(ClassName.LAYOUT_FIXED)) {
          if (offset !== false) {
            $(Selector.CONTENT).css('min-height', max + offset - heights.header - heights.footer);
          }

          if (typeof $.fn.overlayScrollbars !== 'undefined') {
            $(Selector.SIDEBAR).overlayScrollbars({
              className: this._config.scrollbarTheme,
              sizeAutoCapable: true,
              scrollbars: {
                autoHide: this._config.scrollbarAutoHide,
                clickScrolling: true
              }
            });
          }
        }
      };

      _proto.fixLoginRegisterHeight = function fixLoginRegisterHeight() {
        if ($(Selector.LOGIN_BOX + ', ' + Selector.REGISTER_BOX).length === 0) {
          $('body, html').css('height', 'auto');
        } else if ($(Selector.LOGIN_BOX + ', ' + Selector.REGISTER_BOX).length !== 0) {
          var box_height = $(Selector.LOGIN_BOX + ', ' + Selector.REGISTER_BOX).height();

          if ($('body').css('min-height') !== box_height) {
            $('body').css('min-height', box_height);
          }
        }
      } // Private
      ;

      _proto._init = function _init() {
        var _this = this;

        // Activate layout height watcher
        this.fixLayoutHeight();

        if (this._config.loginRegisterAutoHeight === true) {
          this.fixLoginRegisterHeight();
        } else if (Number.isInteger(this._config.loginRegisterAutoHeight)) {
          setInterval(this.fixLoginRegisterHeight, this._config.loginRegisterAutoHeight);
        }

        $(Selector.SIDEBAR).on('collapsed.lte.treeview expanded.lte.treeview', function () {
          _this.fixLayoutHeight();
        });
        $(Selector.PUSHMENU_BTN).on('collapsed.lte.pushmenu shown.lte.pushmenu', function () {
          _this.fixLayoutHeight();
        });
        $(Selector.CONTROL_SIDEBAR_BTN).on('collapsed.lte.controlsidebar', function () {
          _this.fixLayoutHeight();
        }).on('expanded.lte.controlsidebar', function () {
          _this.fixLayoutHeight('control_sidebar');
        });
        $(window).resize(function () {
          _this.fixLayoutHeight();
        });
        setTimeout(function () {
          $('body.hold-transition').removeClass('hold-transition');
        }, 50);
      };

      _proto._max = function _max(numbers) {
        // Calculate the maximum number in a list
        var max = 0;
        Object.keys(numbers).forEach(function (key) {
          if (numbers[key] > max) {
            max = numbers[key];
          }
        });
        return max;
      };

      _proto._isFooterFixed = function _isFooterFixed() {
        return $('.main-footer').css('position') === 'fixed';
      } // Static
      ;

      Layout._jQueryInterface = function _jQueryInterface(config) {
        if (config === void 0) {
          config = '';
        }

        return this.each(function () {
          var data = $(this).data(DATA_KEY);

          var _options = $.extend({}, Default, $(this).data());

          if (!data) {
            data = new Layout($(this), _options);
            $(this).data(DATA_KEY, data);
          }

          if (config === 'init' || config === '') {
            data['_init']();
          } else if (config === 'fixLayoutHeight' || config === 'fixLoginRegisterHeight') {
            data[config]();
          }
        });
      };

      return Layout;
    }();
    /**
     * Data API
     * ====================================================
     */


    $(window).on('load', function () {
      Layout._jQueryInterface.call($('body'));
    });
    $(Selector.SIDEBAR + ' a').on('focusin', function () {
      $(Selector.MAIN_SIDEBAR).addClass(ClassName.SIDEBAR_FOCUSED);
    });
    $(Selector.SIDEBAR + ' a').on('focusout', function () {
      $(Selector.MAIN_SIDEBAR).removeClass(ClassName.SIDEBAR_FOCUSED);
    });
    /**
     * jQuery API
     * ====================================================
     */

    $.fn[NAME] = Layout._jQueryInterface;
    $.fn[NAME].Constructor = Layout;

    $.fn[NAME].noConflict = function () {
      $.fn[NAME] = JQUERY_NO_CONFLICT;
      return Layout._jQueryInterface;
    };

    return Layout;
  }(jQuery);

  /**
   * --------------------------------------------
   * AdminLTE PushMenu.js
   * License MIT
   * --------------------------------------------
   */
  var PushMenu = function ($) {
    /**
     * Constants
     * ====================================================
     */
    var NAME = 'PushMenu';
    var DATA_KEY = 'lte.pushmenu';
    var EVENT_KEY = "." + DATA_KEY;
    var JQUERY_NO_CONFLICT = $.fn[NAME];
    var Event = {
      COLLAPSED: "collapsed" + EVENT_KEY,
      SHOWN: "shown" + EVENT_KEY
    };
    var Default = {
      autoCollapseSize: 992,
      enableRemember: false,
      noTransitionAfterReload: true
    };
    var Selector = {
      TOGGLE_BUTTON: '[data-widget="pushmenu"]',
      SIDEBAR_MINI: '.sidebar-mini',
      SIDEBAR_COLLAPSED: '.sidebar-collapse',
      BODY: 'body',
      OVERLAY: '#sidebar-overlay',
      WRAPPER: '.wrapper'
    };
    var ClassName = {
      COLLAPSED: 'sidebar-collapse',
      OPEN: 'sidebar-open',
      CLOSED: 'sidebar-closed'
    };
    /**
     * Class Definition
     * ====================================================
     */

    var PushMenu = /*#__PURE__*/function () {
      function PushMenu(element, options) {
        this._element = element;
        this._options = $.extend({}, Default, options);

        if (!$(Selector.OVERLAY).length) {
          this._addOverlay();
        }

        this._init();
      } // Public


      var _proto = PushMenu.prototype;

      _proto.expand = function expand() {
        if (this._options.autoCollapseSize) {
          if ($(window).width() <= this._options.autoCollapseSize) {
            $(Selector.BODY).addClass(ClassName.OPEN);
          }
        }

        $(Selector.BODY).removeClass(ClassName.COLLAPSED).removeClass(ClassName.CLOSED);

        if (this._options.enableRemember) {
          localStorage.setItem("remember" + EVENT_KEY, ClassName.OPEN);
        }

        var shownEvent = $.Event(Event.SHOWN);
        $(this._element).trigger(shownEvent);
      };

      _proto.collapse = function collapse() {
        if (this._options.autoCollapseSize) {
          if ($(window).width() <= this._options.autoCollapseSize) {
            $(Selector.BODY).removeClass(ClassName.OPEN).addClass(ClassName.CLOSED);
          }
        }

        $(Selector.BODY).addClass(ClassName.COLLAPSED);

        if (this._options.enableRemember) {
          localStorage.setItem("remember" + EVENT_KEY, ClassName.COLLAPSED);
        }

        var collapsedEvent = $.Event(Event.COLLAPSED);
        $(this._element).trigger(collapsedEvent);
      };

      _proto.toggle = function toggle() {
        if (!$(Selector.BODY).hasClass(ClassName.COLLAPSED)) {
          this.collapse();
        } else {
          this.expand();
        }
      };

      _proto.autoCollapse = function autoCollapse(resize) {
        if (resize === void 0) {
          resize = false;
        }

        if (this._options.autoCollapseSize) {
          if ($(window).width() <= this._options.autoCollapseSize) {
            if (!$(Selector.BODY).hasClass(ClassName.OPEN)) {
              this.collapse();
            }
          } else if (resize == true) {
            if ($(Selector.BODY).hasClass(ClassName.OPEN)) {
              $(Selector.BODY).removeClass(ClassName.OPEN);
            } else if ($(Selector.BODY).hasClass(ClassName.CLOSED)) {
              this.expand();
            }
          }
        }
      };

      _proto.remember = function remember() {
        if (this._options.enableRemember) {
          var toggleState = localStorage.getItem("remember" + EVENT_KEY);

          if (toggleState == ClassName.COLLAPSED) {
            if (this._options.noTransitionAfterReload) {
              $("body").addClass('hold-transition').addClass(ClassName.COLLAPSED).delay(50).queue(function () {
                $(this).removeClass('hold-transition');
                $(this).dequeue();
              });
            } else {
              $("body").addClass(ClassName.COLLAPSED);
            }
          } else {
            if (this._options.noTransitionAfterReload) {
              $("body").addClass('hold-transition').removeClass(ClassName.COLLAPSED).delay(50).queue(function () {
                $(this).removeClass('hold-transition');
                $(this).dequeue();
              });
            } else {
              $("body").removeClass(ClassName.COLLAPSED);
            }
          }
        }
      } // Private
      ;

      _proto._init = function _init() {
        var _this = this;

        this.remember();
        this.autoCollapse();
        $(window).resize(function () {
          _this.autoCollapse(true);
        });
      };

      _proto._addOverlay = function _addOverlay() {
        var _this2 = this;

        var overlay = $('<div />', {
          id: 'sidebar-overlay'
        });
        overlay.on('click', function () {
          _this2.collapse();
        });
        $(Selector.WRAPPER).append(overlay);
      } // Static
      ;

      PushMenu._jQueryInterface = function _jQueryInterface(operation) {
        return this.each(function () {
          var data = $(this).data(DATA_KEY);

          var _options = $.extend({}, Default, $(this).data());

          if (!data) {
            data = new PushMenu(this, _options);
            $(this).data(DATA_KEY, data);
          }

          if (typeof operation === 'string' && operation.match(/collapse|expand|toggle/)) {
            data[operation]();
          }
        });
      };

      return PushMenu;
    }();
    /**
     * Data API
     * ====================================================
     */


    $(document).on('click', Selector.TOGGLE_BUTTON, function (event) {
      event.preventDefault();
      var button = event.currentTarget;

      if ($(button).data('widget') !== 'pushmenu') {
        button = $(button).closest(Selector.TOGGLE_BUTTON);
      }

      PushMenu._jQueryInterface.call($(button), 'toggle');
    });
    $(window).on('load', function () {
      PushMenu._jQueryInterface.call($(Selector.TOGGLE_BUTTON));
    });
    /**
     * jQuery API
     * ====================================================
     */

    $.fn[NAME] = PushMenu._jQueryInterface;
    $.fn[NAME].Constructor = PushMenu;

    $.fn[NAME].noConflict = function () {
      $.fn[NAME] = JQUERY_NO_CONFLICT;
      return PushMenu._jQueryInterface;
    };

    return PushMenu;
  }(jQuery);

  /**
   * --------------------------------------------
   * AdminLTE Treeview.js
   * License MIT
   * --------------------------------------------
   */
  var Treeview = function ($) {
    /**
     * Constants
     * ====================================================
     */
    var NAME = 'Treeview';
    var DATA_KEY = 'lte.treeview';
    var EVENT_KEY = "." + DATA_KEY;
    var JQUERY_NO_CONFLICT = $.fn[NAME];
    var Event = {
      SELECTED: "selected" + EVENT_KEY,
      EXPANDED: "expanded" + EVENT_KEY,
      COLLAPSED: "collapsed" + EVENT_KEY,
      LOAD_DATA_API: "load" + EVENT_KEY
    };
    var Selector = {
      LI: '.nav-item',
      LINK: '.nav-link',
      TREEVIEW_MENU: '.nav-treeview',
      OPEN: '.menu-open',
      DATA_WIDGET: '[data-widget="treeview"]'
    };
    var ClassName = {
      LI: 'nav-item',
      LINK: 'nav-link',
      TREEVIEW_MENU: 'nav-treeview',
      OPEN: 'menu-open',
      SIDEBAR_COLLAPSED: 'sidebar-collapse'
    };
    var Default = {
      trigger: Selector.DATA_WIDGET + " " + Selector.LINK,
      animationSpeed: 300,
      accordion: true,
      expandSidebar: false,
      sidebarButtonSelector: '[data-widget="pushmenu"]'
    };
    /**
     * Class Definition
     * ====================================================
     */

    var Treeview = /*#__PURE__*/function () {
      function Treeview(element, config) {
        this._config = config;
        this._element = element;
      } // Public


      var _proto = Treeview.prototype;

      _proto.init = function init() {
        this._setupListeners();
      };

      _proto.expand = function expand(treeviewMenu, parentLi) {
        var _this = this;

        var expandedEvent = $.Event(Event.EXPANDED);

        if (this._config.accordion) {
          var openMenuLi = parentLi.siblings(Selector.OPEN).first();
          var openTreeview = openMenuLi.find(Selector.TREEVIEW_MENU).first();
          this.collapse(openTreeview, openMenuLi);
        }

        treeviewMenu.stop().slideDown(this._config.animationSpeed, function () {
          parentLi.addClass(ClassName.OPEN);
          $(_this._element).trigger(expandedEvent);
        });

        if (this._config.expandSidebar) {
          this._expandSidebar();
        }
      };

      _proto.collapse = function collapse(treeviewMenu, parentLi) {
        var _this2 = this;

        var collapsedEvent = $.Event(Event.COLLAPSED);
        treeviewMenu.stop().slideUp(this._config.animationSpeed, function () {
          parentLi.removeClass(ClassName.OPEN);
          $(_this2._element).trigger(collapsedEvent);
          treeviewMenu.find(Selector.OPEN + " > " + Selector.TREEVIEW_MENU).slideUp();
          treeviewMenu.find(Selector.OPEN).removeClass(ClassName.OPEN);
        });
      };

      _proto.toggle = function toggle(event) {
        var $relativeTarget = $(event.currentTarget);
        var $parent = $relativeTarget.parent();
        var treeviewMenu = $parent.find('> ' + Selector.TREEVIEW_MENU);

        if (!treeviewMenu.is(Selector.TREEVIEW_MENU)) {
          if (!$parent.is(Selector.LI)) {
            treeviewMenu = $parent.parent().find('> ' + Selector.TREEVIEW_MENU);
          }

          if (!treeviewMenu.is(Selector.TREEVIEW_MENU)) {
            return;
          }
        }

        event.preventDefault();
        var parentLi = $relativeTarget.parents(Selector.LI).first();
        var isOpen = parentLi.hasClass(ClassName.OPEN);

        if (isOpen) {
          this.collapse($(treeviewMenu), parentLi);
        } else {
          this.expand($(treeviewMenu), parentLi);
        }
      } // Private
      ;

      _proto._setupListeners = function _setupListeners() {
        var _this3 = this;

        $(document).on('click', this._config.trigger, function (event) {
          _this3.toggle(event);
        });
      };

      _proto._expandSidebar = function _expandSidebar() {
        if ($('body').hasClass(ClassName.SIDEBAR_COLLAPSED)) {
          $(this._config.sidebarButtonSelector).PushMenu('expand');
        }
      } // Static
      ;

      Treeview._jQueryInterface = function _jQueryInterface(config) {
        return this.each(function () {
          var data = $(this).data(DATA_KEY);

          var _options = $.extend({}, Default, $(this).data());

          if (!data) {
            data = new Treeview($(this), _options);
            $(this).data(DATA_KEY, data);
          }

          if (config === 'init') {
            data[config]();
          }
        });
      };

      return Treeview;
    }();
    /**
     * Data API
     * ====================================================
     */


    $(window).on(Event.LOAD_DATA_API, function () {
      $(Selector.DATA_WIDGET).each(function () {
        Treeview._jQueryInterface.call($(this), 'init');
      });
    });
    /**
     * jQuery API
     * ====================================================
     */

    $.fn[NAME] = Treeview._jQueryInterface;
    $.fn[NAME].Constructor = Treeview;

    $.fn[NAME].noConflict = function () {
      $.fn[NAME] = JQUERY_NO_CONFLICT;
      return Treeview._jQueryInterface;
    };

    return Treeview;
  }(jQuery);

  /**
   * --------------------------------------------
   * AdminLTE DirectChat.js
   * License MIT
   * --------------------------------------------
   */
  var DirectChat = function ($) {
    /**
     * Constants
     * ====================================================
     */
    var NAME = 'DirectChat';
    var DATA_KEY = 'lte.directchat';
    var JQUERY_NO_CONFLICT = $.fn[NAME];
    var Event = {
      TOGGLED: "toggled{EVENT_KEY}"
    };
    var Selector = {
      DATA_TOGGLE: '[data-widget="chat-pane-toggle"]',
      DIRECT_CHAT: '.direct-chat'
    };
    var ClassName = {
      DIRECT_CHAT_OPEN: 'direct-chat-contacts-open'
    };
    /**
     * Class Definition
     * ====================================================
     */

    var DirectChat = /*#__PURE__*/function () {
      function DirectChat(element, config) {
        this._element = element;
      }

      var _proto = DirectChat.prototype;

      _proto.toggle = function toggle() {
        $(this._element).parents(Selector.DIRECT_CHAT).first().toggleClass(ClassName.DIRECT_CHAT_OPEN);
        var toggledEvent = $.Event(Event.TOGGLED);
        $(this._element).trigger(toggledEvent);
      } // Static
      ;

      DirectChat._jQueryInterface = function _jQueryInterface(config) {
        return this.each(function () {
          var data = $(this).data(DATA_KEY);

          if (!data) {
            data = new DirectChat($(this));
            $(this).data(DATA_KEY, data);
          }

          data[config]();
        });
      };

      return DirectChat;
    }();
    /**
     *
     * Data Api implementation
     * ====================================================
     */


    $(document).on('click', Selector.DATA_TOGGLE, function (event) {
      if (event) event.preventDefault();

      DirectChat._jQueryInterface.call($(this), 'toggle');
    });
    /**
     * jQuery API
     * ====================================================
     */

    $.fn[NAME] = DirectChat._jQueryInterface;
    $.fn[NAME].Constructor = DirectChat;

    $.fn[NAME].noConflict = function () {
      $.fn[NAME] = JQUERY_NO_CONFLICT;
      return DirectChat._jQueryInterface;
    };

    return DirectChat;
  }(jQuery);

  /**
   * --------------------------------------------
   * AdminLTE TodoList.js
   * License MIT
   * --------------------------------------------
   */
  var TodoList = function ($) {
    /**
     * Constants
     * ====================================================
     */
    var NAME = 'TodoList';
    var DATA_KEY = 'lte.todolist';
    var JQUERY_NO_CONFLICT = $.fn[NAME];
    var Selector = {
      DATA_TOGGLE: '[data-widget="todo-list"]'
    };
    var ClassName = {
      TODO_LIST_DONE: 'done'
    };
    var Default = {
      onCheck: function onCheck(item) {
        return item;
      },
      onUnCheck: function onUnCheck(item) {
        return item;
      }
    };
    /**
     * Class Definition
     * ====================================================
     */

    var TodoList = /*#__PURE__*/function () {
      function TodoList(element, config) {
        this._config = config;
        this._element = element;

        this._init();
      } // Public


      var _proto = TodoList.prototype;

      _proto.toggle = function toggle(item) {
        item.parents('li').toggleClass(ClassName.TODO_LIST_DONE);

        if (!$(item).prop('checked')) {
          this.unCheck($(item));
          return;
        }

        this.check(item);
      };

      _proto.check = function check(item) {
        this._config.onCheck.call(item);
      };

      _proto.unCheck = function unCheck(item) {
        this._config.onUnCheck.call(item);
      } // Private
      ;

      _proto._init = function _init() {
        var that = this;
        $(Selector.DATA_TOGGLE).find('input:checkbox:checked').parents('li').toggleClass(ClassName.TODO_LIST_DONE);
        $(Selector.DATA_TOGGLE).on('change', 'input:checkbox', function (event) {
          that.toggle($(event.target));
        });
      } // Static
      ;

      TodoList._jQueryInterface = function _jQueryInterface(config) {
        return this.each(function () {
          var data = $(this).data(DATA_KEY);

          var _options = $.extend({}, Default, $(this).data());

          if (!data) {
            data = new TodoList($(this), _options);
            $(this).data(DATA_KEY, data);
          }

          if (config === 'init') {
            data[config]();
          }
        });
      };

      return TodoList;
    }();
    /**
     * Data API
     * ====================================================
     */


    $(window).on('load', function () {
      TodoList._jQueryInterface.call($(Selector.DATA_TOGGLE));
    });
    /**
     * jQuery API
     * ====================================================
     */

    $.fn[NAME] = TodoList._jQueryInterface;
    $.fn[NAME].Constructor = TodoList;

    $.fn[NAME].noConflict = function () {
      $.fn[NAME] = JQUERY_NO_CONFLICT;
      return TodoList._jQueryInterface;
    };

    return TodoList;
  }(jQuery);

  /**
   * --------------------------------------------
   * AdminLTE CardWidget.js
   * License MIT
   * --------------------------------------------
   */
  var CardWidget = function ($) {
    /**
     * Constants
     * ====================================================
     */
    var NAME = 'CardWidget';
    var DATA_KEY = 'lte.cardwidget';
    var EVENT_KEY = "." + DATA_KEY;
    var JQUERY_NO_CONFLICT = $.fn[NAME];
    var Event = {
      EXPANDED: "expanded" + EVENT_KEY,
      COLLAPSED: "collapsed" + EVENT_KEY,
      MAXIMIZED: "maximized" + EVENT_KEY,
      MINIMIZED: "minimized" + EVENT_KEY,
      REMOVED: "removed" + EVENT_KEY
    };
    var ClassName = {
      CARD: 'card',
      COLLAPSED: 'collapsed-card',
      COLLAPSING: 'collapsing-card',
      EXPANDING: 'expanding-card',
      WAS_COLLAPSED: 'was-collapsed',
      MAXIMIZED: 'maximized-card'
    };
    var Selector = {
      DATA_REMOVE: '[data-card-widget="remove"]',
      DATA_COLLAPSE: '[data-card-widget="collapse"]',
      DATA_MAXIMIZE: '[data-card-widget="maximize"]',
      CARD: "." + ClassName.CARD,
      CARD_HEADER: '.card-header',
      CARD_BODY: '.card-body',
      CARD_FOOTER: '.card-footer',
      COLLAPSED: "." + ClassName.COLLAPSED
    };
    var Default = {
      animationSpeed: 'normal',
      collapseTrigger: Selector.DATA_COLLAPSE,
      removeTrigger: Selector.DATA_REMOVE,
      maximizeTrigger: Selector.DATA_MAXIMIZE,
      collapseIcon: 'fa-minus',
      expandIcon: 'fa-plus',
      maximizeIcon: 'fa-expand',
      minimizeIcon: 'fa-compress'
    };

    var CardWidget = /*#__PURE__*/function () {
      function CardWidget(element, settings) {
        this._element = element;
        this._parent = element.parents(Selector.CARD).first();

        if (element.hasClass(ClassName.CARD)) {
          this._parent = element;
        }

        this._settings = $.extend({}, Default, settings);
      }

      var _proto = CardWidget.prototype;

      _proto.collapse = function collapse() {
        var _this = this;

        this._parent.addClass(ClassName.COLLAPSING).children(Selector.CARD_BODY + ", " + Selector.CARD_FOOTER).slideUp(this._settings.animationSpeed, function () {
          _this._parent.addClass(ClassName.COLLAPSED).removeClass(ClassName.COLLAPSING);
        });

        this._parent.find('> ' + Selector.CARD_HEADER + ' ' + this._settings.collapseTrigger + ' .' + this._settings.collapseIcon).addClass(this._settings.expandIcon).removeClass(this._settings.collapseIcon);

        var collapsed = $.Event(Event.COLLAPSED);

        this._element.trigger(collapsed, this._parent);
      };

      _proto.expand = function expand() {
        var _this2 = this;

        this._parent.addClass(ClassName.EXPANDING).children(Selector.CARD_BODY + ", " + Selector.CARD_FOOTER).slideDown(this._settings.animationSpeed, function () {
          _this2._parent.removeClass(ClassName.COLLAPSED).removeClass(ClassName.EXPANDING);
        });

        this._parent.find('> ' + Selector.CARD_HEADER + ' ' + this._settings.collapseTrigger + ' .' + this._settings.expandIcon).addClass(this._settings.collapseIcon).removeClass(this._settings.expandIcon);

        var expanded = $.Event(Event.EXPANDED);

        this._element.trigger(expanded, this._parent);
      };

      _proto.remove = function remove() {
        this._parent.slideUp();

        var removed = $.Event(Event.REMOVED);

        this._element.trigger(removed, this._parent);
      };

      _proto.toggle = function toggle() {
        if (this._parent.hasClass(ClassName.COLLAPSED)) {
          this.expand();
          return;
        }

        this.collapse();
      };

      _proto.maximize = function maximize() {
        this._parent.find(this._settings.maximizeTrigger + ' .' + this._settings.maximizeIcon).addClass(this._settings.minimizeIcon).removeClass(this._settings.maximizeIcon);

        this._parent.css({
          'height': this._parent.height(),
          'width': this._parent.width(),
          'transition': 'all .15s'
        }).delay(150).queue(function () {
          $(this).addClass(ClassName.MAXIMIZED);
          $('html').addClass(ClassName.MAXIMIZED);

          if ($(this).hasClass(ClassName.COLLAPSED)) {
            $(this).addClass(ClassName.WAS_COLLAPSED);
          }

          $(this).dequeue();
        });

        var maximized = $.Event(Event.MAXIMIZED);

        this._element.trigger(maximized, this._parent);
      };

      _proto.minimize = function minimize() {
        this._parent.find(this._settings.maximizeTrigger + ' .' + this._settings.minimizeIcon).addClass(this._settings.maximizeIcon).removeClass(this._settings.minimizeIcon);

        this._parent.css('cssText', 'height:' + this._parent[0].style.height + ' !important;' + 'width:' + this._parent[0].style.width + ' !important; transition: all .15s;').delay(10).queue(function () {
          $(this).removeClass(ClassName.MAXIMIZED);
          $('html').removeClass(ClassName.MAXIMIZED);
          $(this).css({
            'height': 'inherit',
            'width': 'inherit'
          });

          if ($(this).hasClass(ClassName.WAS_COLLAPSED)) {
            $(this).removeClass(ClassName.WAS_COLLAPSED);
          }

          $(this).dequeue();
        });

        var MINIMIZED = $.Event(Event.MINIMIZED);

        this._element.trigger(MINIMIZED, this._parent);
      };

      _proto.toggleMaximize = function toggleMaximize() {
        if (this._parent.hasClass(ClassName.MAXIMIZED)) {
          this.minimize();
          return;
        }

        this.maximize();
      } // Private
      ;

      _proto._init = function _init(card) {
        var _this3 = this;

        this._parent = card;
        $(this).find(this._settings.collapseTrigger).click(function () {
          _this3.toggle();
        });
        $(this).find(this._settings.maximizeTrigger).click(function () {
          _this3.toggleMaximize();
        });
        $(this).find(this._settings.removeTrigger).click(function () {
          _this3.remove();
        });
      } // Static
      ;

      CardWidget._jQueryInterface = function _jQueryInterface(config) {
        var data = $(this).data(DATA_KEY);

        var _options = $.extend({}, Default, $(this).data());

        if (!data) {
          data = new CardWidget($(this), _options);
          $(this).data(DATA_KEY, typeof config === 'string' ? data : config);
        }

        if (typeof config === 'string' && config.match(/collapse|expand|remove|toggle|maximize|minimize|toggleMaximize/)) {
          data[config]();
        } else if (typeof config === 'object') {
          data._init($(this));
        }
      };

      return CardWidget;
    }();
    /**
     * Data API
     * ====================================================
     */


    $(document).on('click', Selector.DATA_COLLAPSE, function (event) {
      if (event) {
        event.preventDefault();
      }

      CardWidget._jQueryInterface.call($(this), 'toggle');
    });
    $(document).on('click', Selector.DATA_REMOVE, function (event) {
      if (event) {
        event.preventDefault();
      }

      CardWidget._jQueryInterface.call($(this), 'remove');
    });
    $(document).on('click', Selector.DATA_MAXIMIZE, function (event) {
      if (event) {
        event.preventDefault();
      }

      CardWidget._jQueryInterface.call($(this), 'toggleMaximize');
    });
    /**
     * jQuery API
     * ====================================================
     */

    $.fn[NAME] = CardWidget._jQueryInterface;
    $.fn[NAME].Constructor = CardWidget;

    $.fn[NAME].noConflict = function () {
      $.fn[NAME] = JQUERY_NO_CONFLICT;
      return CardWidget._jQueryInterface;
    };

    return CardWidget;
  }(jQuery);

  /**
   * --------------------------------------------
   * AdminLTE CardRefresh.js
   * License MIT
   * --------------------------------------------
   */
  var CardRefresh = function ($) {
    /**
     * Constants
     * ====================================================
     */
    var NAME = 'CardRefresh';
    var DATA_KEY = 'lte.cardrefresh';
    var EVENT_KEY = "." + DATA_KEY;
    var JQUERY_NO_CONFLICT = $.fn[NAME];
    var Event = {
      LOADED: "loaded" + EVENT_KEY,
      OVERLAY_ADDED: "overlay.added" + EVENT_KEY,
      OVERLAY_REMOVED: "overlay.removed" + EVENT_KEY
    };
    var ClassName = {
      CARD: 'card'
    };
    var Selector = {
      CARD: "." + ClassName.CARD,
      DATA_REFRESH: '[data-card-widget="card-refresh"]'
    };
    var Default = {
      source: '',
      sourceSelector: '',
      params: {},
      trigger: Selector.DATA_REFRESH,
      content: '.card-body',
      loadInContent: true,
      loadOnInit: true,
      responseType: '',
      overlayTemplate: '<div class="overlay"><i class="fas fa-2x fa-sync-alt fa-spin"></i></div>',
      onLoadStart: function onLoadStart() {},
      onLoadDone: function onLoadDone(response) {
        return response;
      }
    };

    var CardRefresh = /*#__PURE__*/function () {
      function CardRefresh(element, settings) {
        this._element = element;
        this._parent = element.parents(Selector.CARD).first();
        this._settings = $.extend({}, Default, settings);
        this._overlay = $(this._settings.overlayTemplate);

        if (element.hasClass(ClassName.CARD)) {
          this._parent = element;
        }

        if (this._settings.source === '') {
          throw new Error('Source url was not defined. Please specify a url in your CardRefresh source option.');
        }
      }

      var _proto = CardRefresh.prototype;

      _proto.load = function load() {
        this._addOverlay();

        this._settings.onLoadStart.call($(this));

        $.get(this._settings.source, this._settings.params, function (response) {
          if (this._settings.loadInContent) {
            if (this._settings.sourceSelector != '') {
              response = $(response).find(this._settings.sourceSelector).html();
            }

            this._parent.find(this._settings.content).html(response);
          }

          this._settings.onLoadDone.call($(this), response);

          this._removeOverlay();
        }.bind(this), this._settings.responseType !== '' && this._settings.responseType);
        var loadedEvent = $.Event(Event.LOADED);
        $(this._element).trigger(loadedEvent);
      };

      _proto._addOverlay = function _addOverlay() {
        this._parent.append(this._overlay);

        var overlayAddedEvent = $.Event(Event.OVERLAY_ADDED);
        $(this._element).trigger(overlayAddedEvent);
      };

      _proto._removeOverlay = function _removeOverlay() {
        this._parent.find(this._overlay).remove();

        var overlayRemovedEvent = $.Event(Event.OVERLAY_REMOVED);
        $(this._element).trigger(overlayRemovedEvent);
      };

      // Private
      _proto._init = function _init(card) {
        var _this = this;

        $(this).find(this._settings.trigger).on('click', function () {
          _this.load();
        });

        if (this._settings.loadOnInit) {
          this.load();
        }
      } // Static
      ;

      CardRefresh._jQueryInterface = function _jQueryInterface(config) {
        var data = $(this).data(DATA_KEY);

        var _options = $.extend({}, Default, $(this).data());

        if (!data) {
          data = new CardRefresh($(this), _options);
          $(this).data(DATA_KEY, typeof config === 'string' ? data : config);
        }

        if (typeof config === 'string' && config.match(/load/)) {
          data[config]();
        } else {
          data._init($(this));
        }
      };

      return CardRefresh;
    }();
    /**
     * Data API
     * ====================================================
     */


    $(document).on('click', Selector.DATA_REFRESH, function (event) {
      if (event) {
        event.preventDefault();
      }

      CardRefresh._jQueryInterface.call($(this), 'load');
    });
    $(document).ready(function () {
      $(Selector.DATA_REFRESH).each(function () {
        CardRefresh._jQueryInterface.call($(this));
      });
    });
    /**
     * jQuery API
     * ====================================================
     */

    $.fn[NAME] = CardRefresh._jQueryInterface;
    $.fn[NAME].Constructor = CardRefresh;

    $.fn[NAME].noConflict = function () {
      $.fn[NAME] = JQUERY_NO_CONFLICT;
      return CardRefresh._jQueryInterface;
    };

    return CardRefresh;
  }(jQuery);

  /**
   * --------------------------------------------
   * AdminLTE Dropdown.js
   * License MIT
   * --------------------------------------------
   */
  var Dropdown = function ($) {
    /**
     * Constants
     * ====================================================
     */
    var NAME = 'Dropdown';
    var DATA_KEY = 'lte.dropdown';
    var JQUERY_NO_CONFLICT = $.fn[NAME];
    var Selector = {
      NAVBAR: '.navbar',
      DROPDOWN_MENU: '.dropdown-menu',
      DROPDOWN_MENU_ACTIVE: '.dropdown-menu.show',
      DROPDOWN_TOGGLE: '[data-toggle="dropdown"]'
    };
    var ClassName = {
      DROPDOWN_HOVER: 'dropdown-hover',
      DROPDOWN_RIGHT: 'dropdown-menu-right'
    };
    var Default = {};
    /**
     * Class Definition
     * ====================================================
     */

    var Dropdown = /*#__PURE__*/function () {
      function Dropdown(element, config) {
        this._config = config;
        this._element = element;
      } // Public


      var _proto = Dropdown.prototype;

      _proto.toggleSubmenu = function toggleSubmenu() {
        this._element.siblings().show().toggleClass("show");

        if (!this._element.next().hasClass('show')) {
          this._element.parents('.dropdown-menu').first().find('.show').removeClass("show").hide();
        }

        this._element.parents('li.nav-item.dropdown.show').on('hidden.bs.dropdown', function (e) {
          $('.dropdown-submenu .show').removeClass("show").hide();
        });
      };

      _proto.fixPosition = function fixPosition() {
        var elm = $(Selector.DROPDOWN_MENU_ACTIVE);

        if (elm.length !== 0) {
          if (elm.hasClass(ClassName.DROPDOWN_RIGHT)) {
            elm.css('left', 'inherit');
            elm.css('right', 0);
          } else {
            elm.css('left', 0);
            elm.css('right', 'inherit');
          }

          var offset = elm.offset();
          var width = elm.width();
          var windowWidth = $(window).width();
          var visiblePart = windowWidth - offset.left;

          if (offset.left < 0) {
            elm.css('left', 'inherit');
            elm.css('right', offset.left - 5);
          } else {
            if (visiblePart < width) {
              elm.css('left', 'inherit');
              elm.css('right', 0);
            }
          }
        }
      } // Static
      ;

      Dropdown._jQueryInterface = function _jQueryInterface(config) {
        return this.each(function () {
          var data = $(this).data(DATA_KEY);

          var _config = $.extend({}, Default, $(this).data());

          if (!data) {
            data = new Dropdown($(this), _config);
            $(this).data(DATA_KEY, data);
          }

          if (config === 'toggleSubmenu' || config == 'fixPosition') {
            data[config]();
          }
        });
      };

      return Dropdown;
    }();
    /**
     * Data API
     * ====================================================
     */


    $(Selector.DROPDOWN_MENU + ' ' + Selector.DROPDOWN_TOGGLE).on("click", function (event) {
      event.preventDefault();
      event.stopPropagation();

      Dropdown._jQueryInterface.call($(this), 'toggleSubmenu');
    });
    $(Selector.NAVBAR + ' ' + Selector.DROPDOWN_TOGGLE).on("click", function (event) {
      event.preventDefault();
      setTimeout(function () {
        Dropdown._jQueryInterface.call($(this), 'fixPosition');
      }, 1);
    });
    /**
     * jQuery API
     * ====================================================
     */

    $.fn[NAME] = Dropdown._jQueryInterface;
    $.fn[NAME].Constructor = Dropdown;

    $.fn[NAME].noConflict = function () {
      $.fn[NAME] = JQUERY_NO_CONFLICT;
      return Dropdown._jQueryInterface;
    };

    return Dropdown;
  }(jQuery);

  /**
   * --------------------------------------------
   * AdminLTE Toasts.js
   * License MIT
   * --------------------------------------------
   */
  var Toasts = function ($) {
    /**
     * Constants
     * ====================================================
     */
    var NAME = 'Toasts';
    var DATA_KEY = 'lte.toasts';
    var EVENT_KEY = "." + DATA_KEY;
    var JQUERY_NO_CONFLICT = $.fn[NAME];
    var Event = {
      INIT: "init" + EVENT_KEY,
      CREATED: "created" + EVENT_KEY,
      REMOVED: "removed" + EVENT_KEY
    };
    var Selector = {
      BODY: 'toast-body',
      CONTAINER_TOP_RIGHT: '#toastsContainerTopRight',
      CONTAINER_TOP_LEFT: '#toastsContainerTopLeft',
      CONTAINER_BOTTOM_RIGHT: '#toastsContainerBottomRight',
      CONTAINER_BOTTOM_LEFT: '#toastsContainerBottomLeft'
    };
    var ClassName = {
      TOP_RIGHT: 'toasts-top-right',
      TOP_LEFT: 'toasts-top-left',
      BOTTOM_RIGHT: 'toasts-bottom-right',
      BOTTOM_LEFT: 'toasts-bottom-left',
      FADE: 'fade'
    };
    var Position = {
      TOP_RIGHT: 'topRight',
      TOP_LEFT: 'topLeft',
      BOTTOM_RIGHT: 'bottomRight',
      BOTTOM_LEFT: 'bottomLeft'
    };
    var Default = {
      position: Position.TOP_RIGHT,
      fixed: true,
      autohide: false,
      autoremove: true,
      delay: 1000,
      fade: true,
      icon: null,
      image: null,
      imageAlt: null,
      imageHeight: '25px',
      title: null,
      subtitle: null,
      close: true,
      body: null,
      class: null
    };
    /**
     * Class Definition
     * ====================================================
     */

    var Toasts = /*#__PURE__*/function () {
      function Toasts(element, config) {
        this._config = config;

        this._prepareContainer();

        var initEvent = $.Event(Event.INIT);
        $('body').trigger(initEvent);
      } // Public


      var _proto = Toasts.prototype;

      _proto.create = function create() {
        var toast = $('<div class="toast" role="alert" aria-live="assertive" aria-atomic="true"/>');
        toast.data('autohide', this._config.autohide);
        toast.data('animation', this._config.fade);

        if (this._config.class) {
          toast.addClass(this._config.class);
        }

        if (this._config.delay && this._config.delay != 500) {
          toast.data('delay', this._config.delay);
        }

        var toast_header = $('<div class="toast-header">');

        if (this._config.image != null) {
          var toast_image = $('<img />').addClass('rounded mr-2').attr('src', this._config.image).attr('alt', this._config.imageAlt);

          if (this._config.imageHeight != null) {
            toast_image.height(this._config.imageHeight).width('auto');
          }

          toast_header.append(toast_image);
        }

        if (this._config.icon != null) {
          toast_header.append($('<i />').addClass('mr-2').addClass(this._config.icon));
        }

        if (this._config.title != null) {
          toast_header.append($('<strong />').addClass('mr-auto').html(this._config.title));
        }

        if (this._config.subtitle != null) {
          toast_header.append($('<small />').html(this._config.subtitle));
        }

        if (this._config.close == true) {
          var toast_close = $('<button data-dismiss="toast" />').attr('type', 'button').addClass('ml-2 mb-1 close').attr('aria-label', 'Close').append('<span aria-hidden="true">&times;</span>');

          if (this._config.title == null) {
            toast_close.toggleClass('ml-2 ml-auto');
          }

          toast_header.append(toast_close);
        }

        toast.append(toast_header);

        if (this._config.body != null) {
          toast.append($('<div class="toast-body" />').html(this._config.body));
        }

        $(this._getContainerId()).prepend(toast);
        var createdEvent = $.Event(Event.CREATED);
        $('body').trigger(createdEvent);
        toast.toast('show');

        if (this._config.autoremove) {
          toast.on('hidden.bs.toast', function () {
            $(this).delay(200).remove();
            var removedEvent = $.Event(Event.REMOVED);
            $('body').trigger(removedEvent);
          });
        }
      } // Static
      ;

      _proto._getContainerId = function _getContainerId() {
        if (this._config.position == Position.TOP_RIGHT) {
          return Selector.CONTAINER_TOP_RIGHT;
        } else if (this._config.position == Position.TOP_LEFT) {
          return Selector.CONTAINER_TOP_LEFT;
        } else if (this._config.position == Position.BOTTOM_RIGHT) {
          return Selector.CONTAINER_BOTTOM_RIGHT;
        } else if (this._config.position == Position.BOTTOM_LEFT) {
          return Selector.CONTAINER_BOTTOM_LEFT;
        }
      };

      _proto._prepareContainer = function _prepareContainer() {
        if ($(this._getContainerId()).length === 0) {
          var container = $('<div />').attr('id', this._getContainerId().replace('#', ''));

          if (this._config.position == Position.TOP_RIGHT) {
            container.addClass(ClassName.TOP_RIGHT);
          } else if (this._config.position == Position.TOP_LEFT) {
            container.addClass(ClassName.TOP_LEFT);
          } else if (this._config.position == Position.BOTTOM_RIGHT) {
            container.addClass(ClassName.BOTTOM_RIGHT);
          } else if (this._config.position == Position.BOTTOM_LEFT) {
            container.addClass(ClassName.BOTTOM_LEFT);
          }

          $('body').append(container);
        }

        if (this._config.fixed) {
          $(this._getContainerId()).addClass('fixed');
        } else {
          $(this._getContainerId()).removeClass('fixed');
        }
      } // Static
      ;

      Toasts._jQueryInterface = function _jQueryInterface(option, config) {
        return this.each(function () {
          var _options = $.extend({}, Default, config);

          var toast = new Toasts($(this), _options);

          if (option === 'create') {
            toast[option]();
          }
        });
      };

      return Toasts;
    }();
    /**
     * jQuery API
     * ====================================================
     */


    $.fn[NAME] = Toasts._jQueryInterface;
    $.fn[NAME].Constructor = Toasts;

    $.fn[NAME].noConflict = function () {
      $.fn[NAME] = JQUERY_NO_CONFLICT;
      return Toasts._jQueryInterface;
    };

    return Toasts;
  }(jQuery);

  exports.CardRefresh = CardRefresh;
  exports.CardWidget = CardWidget;
  exports.ControlSidebar = ControlSidebar;
  exports.DirectChat = DirectChat;
  exports.Dropdown = Dropdown;
  exports.Layout = Layout;
  exports.PushMenu = PushMenu;
  exports.Toasts = Toasts;
  exports.TodoList = TodoList;
  exports.Treeview = Treeview;

  Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=adminlte.js.map
