<?php

// 手動引入 Factory 和 UrlService 類文件
require_once 'src/Factories/Factory.php';
require_once 'src/Services/UrlService.php';
require_once 'src/Services/CheckMacValueService.php';
require_once 'src/Traits/HashInfo.php';

use Ecpay\Sdk\Factories\Factory;
use Ecpay\Sdk\Services\UrlService;
use Ecpay\Sdk\Services\CheckMacValueService;
use Ecpay\Sdk\Traits\HashInfo;

$factory = new Factory([
    'hashKey' => 'pwFHCqoQZGmho4w6',
    'hashIv'  => 'EkRm7iFT261dpevs',
]);
$autoSubmitFormService = $factory->create('AutoSubmitFormWithCmvService');

$MerchantTradeNo = $_POST['MerchantTradeNo'] ?? '3002607';
$totalAmount = $_POST['TotalAmount'] ?? 100;
$itemName = $_POST['ItemName'] ?? '範例商品一批 100 TWD x 1';

$input = [
  'MerchantID'        => '3002607',
  'MerchantTradeNo'   => $MerchantTradeNo,
  'MerchantTradeDate' => date('Y/m/d H:i:s'),
  'PaymentType'       => 'aio',
  'TotalAmount'       => $totalAmount,
  'TradeDesc'         => UrlService::ecpayUrlEncode($itemName),
  'ItemName'          => $itemName,
  'ChoosePayment'     => 'Credit',
  'EncryptType'       => 1,
  'ReturnURL'         => 'https://aoxio.kayle.io/customer/appointments',
];
$action = 'https://payment-stage.ecpay.com.tw/Cashier/AioCheckOut/V5';

echo $autoSubmitFormService->generate($input, $action);
