<?php

ob_start(); 

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // 1. 取得 POST 參數
    $order_id = $_POST['order_id'] ?? null;
    $amount = $_POST['amount'] ?? null;
    $staff_name = $_POST['staff_name'] ?? null;

    if (!$order_id || !$amount || !$staff_name) {
        echo "缺少必要的參數！";
        exit;
    }

    // 2. 設定 LINE Pay API 設定
    $channelId = '2006782725'; // 使用您的 Channel ID
    $channelSecret = '86629a83b89fd654a249d58c5d2f36bd'; // 使用您的 Channel Secret
    $url = '/v3/payments/request';  // API路徑

    // 3. 隨機生成唯一的 Nonce
    $nonce = uniqid('', true); 

    // 4. 構建請求載荷 (Request Payload)
    $requestPayload = [
        'amount' => (int) $amount,
        'currency' => 'TWD',
        'orderId' => $order_id,
        'packages' => [
            [
                'id' => $order_id,
                'amount' => (int) $amount,
                'products' => [
                    [
                        'id' => $order_id,
                        'name' => $staff_name,
                        'quantity' => 1,
                        'price' => (int) $amount,
                    ]
                ]
            ]
        ],
        'redirectUrls' => [
            'confirmUrl' => 'https://aoxio.kayle.io/customer/appointments',
            'cancelUrl' => 'https://aoxio.kayle.io/customer/appointments',
        ]
    ];

    // 5. 將請求載荷轉換為 JSON
    $payloadJson = json_encode($requestPayload);

    // 6. 構建待簽名的字串：ChannelSecret + API路徑 + Request Body + Nonce
    $dataToSign = $channelSecret . $url . $payloadJson . $nonce;

    // 7. 計算簽名 (使用 HMAC-SHA256)
    $signature = base64_encode(hash_hmac('sha256', $dataToSign, $channelSecret, true));

    // 8. Debug印出需要簽名的資料
    echo "channelId: " . $channelId . "\n";
    echo "nonce: " . $nonce . "\n";
    echo "signature: " . $signature . "\n";

    // 9. 設置 HTTP 請求的 Header
    $headers = [
        'Content-Type: application/json',
        'X-LINE-ChannelId: ' . $channelId,
        'X-LINE-Authorization-Nonce: ' . $nonce,
        'X-LINE-Authorization: ' . $signature,  // 使用 HMAC-SHA256 計算的簽名
    ];

    // 10. 發送 API 請求至 LINE Pay
    $ch = curl_init('https://api-pay.line.me/v3/payments/request');  // 正確的 URL
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payloadJson);  // 使用 JSON 作為請求主體
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    curl_close($ch);

    if ($response === false) {
        echo "LINE Pay API 請求失敗";
        exit;
    }

    // 11. 解析 API 回應
    $responseData = json_decode($response, true);

    // 12. 根據 API 回應進行處理
    if ($responseData['returnCode'] === '0000') {
        $paymentUrl = $responseData['info']['paymentUrl']['web'];  // 提取支付頁面 URL
        header("Location: $paymentUrl");  // 重定向到 LINE Pay 支付頁面
        exit;
    } else {
        echo "LINE Pay API 回傳錯誤: " . $responseData['returnMessage'];  // 顯示錯誤消息
        exit;
    }
} else {
    echo "不允許的請求方法！";
}

ob_end_flush(); 
?>